<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_send_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('api_target_id')->constrained()->cascadeOnDelete(); // Relasi ke api_targets
            $table->integer('records_sent')->default(0); // Jumlah record yang dikirim
            $table->json('payload')->nullable(); // Data yang dikirim
            $table->integer('status_code')->nullable(); // HTTP status code response
            $table->integer('response_time')->nullable(); // Response time dalam ms
            $table->json('response_body')->nullable(); // Response dari API target
            $table->text('error_message')->nullable(); // Error message jika gagal
            $table->boolean('success')->default(false); // Status berhasil/gagal
            $table->integer('retry_count')->default(0); // Jumlah retry yang dilakukan
            $table->timestamp('sent_at'); // Waktu pengiriman
            $table->timestamp('completed_at')->nullable(); // Waktu selesai (untuk tracking durasi)
            $table->string('batch_id')->nullable(); // ID batch untuk grouping
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_send_logs');
    }
};
