<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_receivers', function (Blueprint $table) {
            $table->id();
            $table->string('name')->comment('Nama endpoint yang mudah dibaca');
            $table->string('endpoint')->unique()->comment('URL path endpoint (contoh: crypto-harga)');
            $table->string('target_table')->comment('Nama tabel tujuan penyimpanan data');
            $table->enum('auth_type', ['none', 'api_key', 'bearer_token', 'hmac_signature'])->default('none');
            $table->string('auth_token')->nullable()->comment('API Key atau Bearer Token');
            $table->text('auth_secret')->nullable()->comment('Secret key untuk HMAC signature');
            $table->text('allowed_ips')->nullable()->comment('IP whitelist (JSON array)');
            $table->json('allowed_headers')->nullable()->comment('Headers yang diizinkan');
            $table->json('field_mapping')->nullable()->comment('Mapping field dari request ke database');
            $table->json('validation_rules')->nullable()->comment('Aturan validasi untuk field GET/query parameters');
            $table->boolean('auto_create_table')->default(false)->comment('Auto create table dari sample data');
            $table->boolean('is_active')->default(true);
            $table->integer('rate_limit')->default(1000)->comment('Requests per hour limit');
            $table->enum('allowed_methods', ['POST', 'PUT', 'PATCH', 'POST,PUT', 'POST,PATCH', 'PUT,PATCH', 'POST,PUT,PATCH', 'GET,POST'])->default('POST');
            $table->text('description')->nullable();
            $table->json('sample_data')->nullable()->comment('Contoh data untuk dokumentasi');
            $table->boolean('is_bidirectional')->default(false);
            $table->enum('duplicate_handling', ['update', 'ignore', 'error'])->default('error');
            $table->string('unique_fields')->nullable();
            $table->enum('data_filter', ['all', 'new', 'updated'])->default('all');
            $table->tinyInteger('max_records_per_request')->default(100);
            $table->boolean('enable_scheduling')->default(false);
            $table->enum('schedule_type', ['manual', 'interval', 'cron'])->default('manual');
            $table->integer('schedule_interval')->nullable();
            $table->string('timezone')->default('UTC');
            $table->enum('response_format', ['json', 'xml'])->default('json');
            $table->boolean('auto_acknowledge')->default(true);
            $table->tinyInteger('retry_attempts')->default(3);
            $table->integer('retry_delay')->default(60);
            $table->timestamp('last_received_at')->nullable();
            $table->integer('total_received')->default(0);
            $table->timestamps();
            
            $table->index(['endpoint', 'is_active']);
            $table->index('target_table');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_receivers');
    }
};
