<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_transceivers', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Transceiver name
            $table->text('description')->nullable(); // Description
            $table->foreignId('api_client_id')->constrained('api_clients');
            $table->foreignId('api_receiver_id')->constrained('api_receivers');
            $table->foreignId('api_target_id')->constrained('api_targets');
            $table->string('direction', 20)->default('bidirectional');
            $table->boolean('is_active')->default(true); // Active status
            $table->boolean('auto_sync')->default(false);
            $table->string('schedule_type', 20)->default('manual');
            $table->integer('sync_interval')->nullable();
            $table->string('cron_expression')->nullable();
            $table->json('field_mapping')->nullable(); // Field mapping from receiver to target
            $table->timestamp('last_sync_at')->nullable();
            $table->integer('total_synced')->default(0); // Total synced count
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['is_active']);
            $table->index(['api_client_id', 'api_receiver_id', 'api_target_id'], 'idx_transceiver_relations');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_transceivers');
    }
}; 