<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_receive_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('receiver_id')->constrained('api_receivers')->onDelete('cascade');
            $table->string('method', 10)->comment('HTTP Method (POST, PUT, PATCH)');
            $table->string('ip_address', 45)->comment('IP address pengirim');
            $table->string('user_agent')->nullable();
            $table->json('headers')->nullable()->comment('Request headers');
            $table->longText('body')->nullable()->comment('Request body/payload');
            $table->json('query_params')->nullable()->comment('Query parameters');
            $table->integer('status_code')->comment('Response status code');
            $table->text('response_message')->nullable()->comment('Response message');
            $table->float('response_time')->nullable()->comment('Response time in milliseconds');
            $table->integer('payload_size')->nullable()->comment('Request payload size in bytes');
            $table->boolean('auth_success')->default(false);
            $table->string('auth_error')->nullable();
            $table->boolean('validation_success')->default(false);
            $table->json('validation_errors')->nullable();
            $table->boolean('saved_to_table')->default(false);
            $table->string('save_error')->nullable();
            $table->string('reference_id')->nullable()->comment('ID data yang disimpan ke target table');
            $table->timestamps();
            
            $table->index(['receiver_id', 'created_at']);
            $table->index(['ip_address', 'created_at']);
            $table->index(['status_code', 'created_at']);
            $table->index('method');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_receive_logs');
    }
};
