<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_transceiver_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('api_transceiver_id')->constrained()->cascadeOnDelete(); // Parent transceiver
            $table->foreignId('api_receiver_log_id')->nullable()->constrained('api_receive_logs')->nullOnDelete(); // Source log
            $table->foreignId('api_send_log_id')->nullable()->constrained()->nullOnDelete(); // Target send log
            $table->json('source_data'); // Original data from receiver
            $table->json('transformed_data'); // Transformed data sent to target
            $table->json('target_response')->nullable(); // Response from target API
            $table->integer('response_time'); // Processing time in ms
            $table->boolean('success')->default(false); // Success status
            $table->text('error_message')->nullable(); // Error message if failed
            $table->timestamp('processed_at'); // Processing timestamp
            $table->timestamps();
            
            // Indexes for performance
            $table->index(['api_transceiver_id', 'processed_at']);
            $table->index(['success', 'processed_at']);
            $table->index(['api_receiver_log_id']);
            $table->index(['api_send_log_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_transceiver_logs');
    }
}; 