<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('api_sources', function (Blueprint $table) {
            // Check and add columns only if they don't exist
            if (!Schema::hasColumn('api_sources', 'auth_type')) {
                $table->string('auth_type')->default('none')->after('url');
            }
            
            if (!Schema::hasColumn('api_sources', 'auth_token')) {
                $table->text('auth_token')->nullable()->after('auth_type');
            }
            
            if (!Schema::hasColumn('api_sources', 'description')) {
                $table->text('description')->nullable()->after('sample_data');
            }
        });
        
        // Add indexes separately to avoid conflicts
        try {
            Schema::table('api_sources', function (Blueprint $table) {
                if (Schema::hasColumn('api_sources', 'auth_type')) {
                    $table->index('auth_type');
                }
            });
        } catch (\Exception $e) {
            // Index might already exist, ignore
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('api_sources', function (Blueprint $table) {
            // Drop indexes first
            try {
                $table->dropIndex(['auth_type']);
            } catch (\Exception $e) {
                // Index might not exist, ignore
            }
            
            // Drop columns if they exist
            $columnsToRemove = [];
            if (Schema::hasColumn('api_sources', 'auth_type')) {
                $columnsToRemove[] = 'auth_type';
            }
            if (Schema::hasColumn('api_sources', 'auth_token')) {
                $columnsToRemove[] = 'auth_token';
            }
            if (Schema::hasColumn('api_sources', 'description')) {
                $columnsToRemove[] = 'description';
            }
            
            if (!empty($columnsToRemove)) {
                $table->dropColumn($columnsToRemove);
            }
        });
    }
};
