<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update the enum to include all HTTP methods that are used in the form
        DB::statement("ALTER TABLE api_receivers MODIFY COLUMN allowed_methods ENUM('GET', 'POST', 'PUT', 'PATCH', 'DELETE', 'GET,POST', 'GET,PUT', 'GET,PATCH', 'GET,DELETE', 'POST,PUT', 'POST,PATCH', 'POST,DELETE', 'PUT,PATCH', 'PUT,DELETE', 'PATCH,DELETE', 'GET,POST,PUT', 'GET,POST,PATCH', 'GET,POST,DELETE', 'GET,PUT,PATCH', 'GET,PUT,DELETE', 'GET,PATCH,DELETE', 'POST,PUT,PATCH', 'POST,PUT,DELETE', 'POST,PATCH,DELETE', 'PUT,PATCH,DELETE', 'GET,POST,PUT,PATCH', 'GET,POST,PUT,DELETE', 'GET,POST,PATCH,DELETE', 'GET,PUT,PATCH,DELETE', 'POST,PUT,PATCH,DELETE', 'GET,POST,PUT,PATCH,DELETE') DEFAULT 'POST'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert back to original enum
        DB::statement("ALTER TABLE api_receivers MODIFY COLUMN allowed_methods ENUM('POST', 'PUT', 'PATCH', 'POST,PUT', 'POST,PATCH', 'PUT,PATCH', 'POST,PUT,PATCH') DEFAULT 'POST'");
    }
};
