<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('api_sources', function (Blueprint $table) {
            // Add missing columns if they don't exist
            if (!Schema::hasColumn('api_sources', 'status')) {
                $table->enum('status', ['active', 'inactive'])->default('active')->after('table_name');
            }
            
            if (!Schema::hasColumn('api_sources', 'method')) {
                $table->enum('method', ['POST'])->default('POST')->after('url');
            }
            
            if (!Schema::hasColumn('api_sources', 'schedule_type')) {
                $table->enum('schedule_type', ['manual', 'hourly', 'daily', 'weekly'])->default('manual')->after('status');
            }
            
            if (!Schema::hasColumn('api_sources', 'schedule_frequency')) {
                $table->integer('schedule_frequency')->nullable()->after('schedule_type');
            }
            
            if (!Schema::hasColumn('api_sources', 'created_by')) {
                $table->unsignedBigInteger('created_by')->nullable()->after('last_fetched_at');
            }
            
            if (!Schema::hasColumn('api_sources', 'headers')) {
                $table->json('headers')->nullable()->after('method');
            }
            
            if (!Schema::hasColumn('api_sources', 'field_mapping')) {
                $table->json('field_mapping')->nullable()->after('table_name');
            }
            
            if (!Schema::hasColumn('api_sources', 'sample_data')) {
                $table->json('sample_data')->nullable()->after('field_mapping');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('api_sources', function (Blueprint $table) {
            $columns = ['status', 'method', 'schedule_type', 'schedule_frequency', 'created_by', 'headers', 'field_mapping', 'sample_data'];
            
            foreach ($columns as $column) {
                if (Schema::hasColumn('api_sources', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
