<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Change allowed_methods from enum to string for more flexibility
        Schema::table('api_receivers', function (Blueprint $table) {
            $table->string('allowed_methods', 100)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert back to enum with original values
        DB::statement("ALTER TABLE api_receivers MODIFY COLUMN allowed_methods ENUM('POST', 'PUT', 'PATCH', 'POST,PUT', 'POST,PATCH', 'PUT,PATCH', 'POST,PUT,PATCH') DEFAULT 'POST'");
    }
};
