<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('api_targets', function (Blueprint $table) {
            $table->enum('schedule_type', ['manual', 'interval', 'cron'])->default('manual')->after('source_table');
            $table->integer('schedule_frequency')->nullable()->after('schedule_type');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('api_targets', function (Blueprint $table) {
            $table->dropColumn(['schedule_type', 'schedule_frequency']);
        });
    }
}; 