<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update data_filter enum to match controller validation
        DB::statement("ALTER TABLE api_receivers MODIFY COLUMN data_filter ENUM('all', 'latest_only', 'today_only', 'last_24h', 'last_week', 'new', 'updated') DEFAULT 'all'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert to original enum values
        DB::statement("ALTER TABLE api_receivers MODIFY COLUMN data_filter ENUM('all', 'new', 'updated') DEFAULT 'all'");
    }
}; 