<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Update duplicate_handling enum to match form values
        DB::statement("ALTER TABLE api_receivers MODIFY COLUMN duplicate_handling ENUM('allow', 'skip', 'update', 'reject') DEFAULT 'skip'");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Revert to original enum values
        DB::statement("ALTER TABLE api_receivers MODIFY COLUMN duplicate_handling ENUM('update', 'ignore', 'error') DEFAULT 'error'");
    }
}; 