<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('api_receivers', function (Blueprint $table) {
            // Change max_records_per_request from tinyInteger to string to support 'unlimited'
            $table->string('max_records_per_request', 20)->default('100')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('api_receivers', function (Blueprint $table) {
            // Revert back to tinyInteger
            $table->tinyInteger('max_records_per_request')->default(100)->change();
        });
    }
}; 