<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('api_receivers', function (Blueprint $table) {
            if (!Schema::hasColumn('api_receivers', 'auth_username')) {
                $table->string('auth_username')->nullable()->after('auth_token');
            }
            if (!Schema::hasColumn('api_receivers', 'auth_password')) {
                $table->string('auth_password')->nullable()->after('auth_username');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('api_receivers', function (Blueprint $table) {
            if (Schema::hasColumn('api_receivers', 'auth_username')) {
                $table->dropColumn('auth_username');
            }
            if (Schema::hasColumn('api_receivers', 'auth_password')) {
                $table->dropColumn('auth_password');
            }
        });
    }
};
