<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('TEST', function (Blueprint $table) {
            $table->id();
            $table->decimal('sell', 15, 2)->nullable();
            $table->decimal('buy', 15, 2)->nullable();
            $table->string('type')->nullable();
            $table->text('info')->nullable();
            $table->decimal('weight', 10, 2)->nullable();
            $table->string('unit')->nullable();
            $table->string('source')->nullable(); // anekalogam, logammulia, etc.
            $table->json('raw_data')->nullable(); // Store complete API response
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('TEST');
    }
};
