<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('api_tokens', function (Blueprint $table) {
            if (!Schema::hasColumn('api_tokens', 'name')) {
                $table->string('name')->nullable()->after('api_client_id');
            }
        });

        // Backfill reasonable defaults for existing rows
        if (Schema::hasColumn('api_tokens', 'name')) {
            DB::table('api_tokens')
                ->whereNull('name')
                ->update(['name' => DB::raw("CONCAT('Token ', id)")]);

            DB::table('api_tokens')
                ->where('name', '=','')
                ->update(['name' => DB::raw("CONCAT('Token ', id)")]);
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('api_tokens', function (Blueprint $table) {
            if (Schema::hasColumn('api_tokens', 'name')) {
                $table->dropColumn('name');
            }
        });
    }
};


