<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ApiClient;
use Illuminate\Support\Str;

class ApiClientSeeder extends Seeder
{
    public function run(): void
    {
        // Create a sample API Client
        ApiClient::create([
            'name' => 'Default API Client',
            'description' => 'Default API client for testing',
            'client_id' => Str::uuid(),
            'client_secret' => Str::random(64),
            'usertoken' => Str::uuid(),
            'passtoken' => Str::random(32),
            'is_active' => true,
            'rate_limit' => 1000
        ]);

        // Create test client
        ApiClient::create([
            'name' => 'Test Client',
            'description' => 'Client for testing API tokens',
            'is_active' => true,
            'settings' => ['test' => true],
            'created_by' => 1
        ]);
    }
} 