<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ApiReceiver;
use Illuminate\Support\Str;

class BadenBasicAuthSeeder extends Seeder
{
    public function run()
    {
        // Create API Receiver with Basic Auth
        $receiver = ApiReceiver::create([
            'name' => 'Baden Basic Auth Receiver',
            'description' => 'Receiver for Baden System with Basic Authentication',
            'endpoint' => 'baden',
            'target_table' => 'orders',
            'auth_type' => 'basic_auth',
            'auth_username' => 'baden',
            'auth_password' => 'baden',
            'allowed_methods' => 'GET,POST,PUT,DELETE',
            'rate_limit' => 100,
            'auto_create_table' => true,
            'is_active' => true,
            'is_bidirectional' => true,
            'duplicate_handling' => 'update',
            'unique_fields' => 'order_id',
            'data_filter' => 'all',
            'max_records_per_request' => 100,
            'enable_scheduling' => true,
            'schedule_type' => 'interval',
            'schedule_interval' => 5,
            'timezone' => 'Asia/Jakarta',
            'response_format' => 'json',
            'auto_acknowledge' => true,
            'retry_attempts' => 3,
            'retry_delay' => 60,
            'validation_rules' => json_encode([
                'order_id' => ['required' => true, 'type' => 'string'],
                'customer_name' => ['required' => true, 'type' => 'string'],
                'total_amount' => ['required' => true, 'type' => 'numeric']
            ])
        ]);

        // Output configuration details
        $this->command->info('Baden Basic Auth Receiver Setup Complete!');
        $this->command->info('Receiver ID: ' . $receiver->id);
        $this->command->info('Endpoint: /api/in/' . $receiver->endpoint);
        $this->command->info('Username: ' . $receiver->auth_username);
        $this->command->info('Password: ' . $receiver->auth_password);
        $this->command->info('Basic Auth Header: Basic ' . base64_encode($receiver->auth_username . ':' . $receiver->auth_password));
    }
}
