<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ApiClient;
use App\Models\ApiReceiver;
use App\Models\ApiTarget;
use App\Models\ApiTransceiver;
use Illuminate\Support\Str;

class BadenTransceiverSeeder extends Seeder
{
    public function run()
    {
        // 1. Create API Client
        $client = ApiClient::create([
            'name' => 'Baden Client',
            'description' => 'Client for Baden Transceiver System',
            'is_active' => true,
            'client_id' => 'baden_' . Str::random(32),
            'client_secret' => Str::random(64),
            'usertoken' => 'ut_' . Str::random(32),
            'passtoken' => 'pt_' . Str::random(32),
            'rate_limit' => 1000
        ]);

        // 2. Create API Receiver
        $receiver = ApiReceiver::create([
            'name' => 'Baden Receiver',
            'description' => 'Receiver for Baden System',
            'endpoint' => 'baden-nurpadilah',
            'target_table' => 'orders',
            'auth_type' => 'none',
            'allowed_methods' => 'GET,POST',
            'rate_limit' => 100,
            'auto_create_table' => true,
            'is_active' => true,
            'is_bidirectional' => true,
            'duplicate_handling' => 'update',
            'unique_fields' => 'order_id',
            'data_filter' => 'all',
            'max_records_per_request' => 100,
            'enable_scheduling' => true,
            'schedule_type' => 'interval',
            'schedule_interval' => 5,
            'timezone' => 'Asia/Jakarta',
            'response_format' => 'json',
            'auto_acknowledge' => true,
            'retry_attempts' => 3,
            'retry_delay' => 60,
            'validation_rules' => json_encode([
                'order_id' => ['required' => true, 'type' => 'string'],
                'customer_name' => ['required' => true, 'type' => 'string'],
                'total_amount' => ['required' => true, 'type' => 'numeric']
            ])
        ]);

        // 3. Create API Target
        $target = ApiTarget::create([
            'name' => 'Baden Target',
            'description' => 'Target System for Baden',
            'base_url' => 'http://target-system.test',
            'endpoint' => '/api/data',
            'method' => 'POST',
            'source_table' => 'orders',
            'headers' => json_encode([
                'Content-Type' => 'application/json',
                'Accept' => 'application/json'
            ]),
            'auth_type' => 'bearer_token',
            'auth_token' => Str::random(60),
            'field_mapping' => json_encode([
                'order_id' => 'id',
                'customer_name' => 'customer',
                'total_amount' => 'amount'
            ]),
            'is_active' => true,
            'callback_url' => 'http://127.0.0.1:8000/api/in/baden-nurpadilah',
            'callback_method' => 'POST',
            'success_response_template' => json_encode([
                'success' => true,
                'message' => 'Data received successfully'
            ]),
            'error_response_template' => json_encode([
                'success' => false,
                'message' => 'Error processing data'
            ]),
            'timeout' => 30,
            'total_forwarded' => 0
        ]);

        // 4. Create API Transceiver
        $transceiver = ApiTransceiver::create([
            'name' => 'Baden Transceiver',
            'description' => 'Bidirectional Transceiver for Baden System',
            'api_client_id' => $client->id,
            'api_receiver_id' => $receiver->id,
            'api_target_id' => $target->id,
            'direction' => 'bidirectional',
            'is_active' => true,
            'auto_sync' => true,
            'schedule_type' => 'interval',
            'sync_interval' => 5,
            'field_mapping' => json_encode([
                'order_id' => 'order_id',
                'customer_name' => 'customer_name',
                'total_amount' => 'total_amount'
            ])
        ]);

        // Output configuration details
        $this->command->info('Baden Transceiver Setup Complete!');
        $this->command->info('API Client ID: ' . $client->id);
        $this->command->info('Client Token: ' . $client->usertoken);
        $this->command->info('Receiver Endpoint: /api/in/' . $receiver->endpoint);
        $this->command->info('Target Auth Token: ' . $target->auth_token);
        $this->command->info('Transceiver ID: ' . $transceiver->id);
    }
} 