<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeder.
     */
    public function run(): void
    {
        // Create admin user
        User::firstOrCreate(
            ['email' => 'admin@api-management.com'],
            [
                'name' => 'API Admin',
                'password' => Hash::make('admin123'),
                'email_verified_at' => now()
            ]
        );

        // Create monitoring user
        User::firstOrCreate(
            ['email' => 'monitoring@api-management.com'],
            [
                'name' => 'Monitoring User',
                'password' => Hash::make('monitor123'),
                'email_verified_at' => now()
            ]
        );

        // Create developer user
        User::firstOrCreate(
            ['email' => 'developer@api-management.com'],
            [
                'name' => 'Developer',
                'password' => Hash::make('dev123'),
                'email_verified_at' => now()
            ]
        );
    }
} 