<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class WimDataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Seed WIM Prasarana data
        DB::table('wim_prasarana')->insert([
            [
                'id_wim' => 'WIM001',
                'nama_lokasi' => 'Pos WIM Jakarta Barat',
                'tipe' => 'Fixed WIM',
                'dimensi' => '3.5m x 18m',
                'tahun_pembuatan' => 2020,
                'kondisi' => 'Baik',
                'keterangan' => 'Pos WIM permanen di Jalan Raya Jakarta Barat',
                'status' => 'aktif',
                'latitude' => -6.2088,
                'longitude' => 106.8456,
                'alamat' => 'Jalan Raya Jakarta Barat No. 123',
                'provinsi' => 'DKI Jakarta',
                'kabupaten' => 'Jakarta Barat',
                'kecamatan' => 'Grogol Petamburan',
                'desa' => 'Grogol',
                'kode_pos' => '11450',
                'nomor_telepon' => '021-1234567',
                'email' => 'wim.jakbar@hubnet.go.id',
                'penanggung_jawab' => 'Ir. Budi Santoso',
                'is_sent_to_hubnet' => false,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id_wim' => 'WIM002',
                'nama_lokasi' => 'Pos WIM Bandung',
                'tipe' => 'Portable WIM',
                'dimensi' => '3.5m x 15m',
                'tahun_pembuatan' => 2021,
                'kondisi' => 'Baik',
                'keterangan' => 'Pos WIM portable di Jalan Raya Bandung',
                'status' => 'aktif',
                'latitude' => -6.9175,
                'longitude' => 107.6191,
                'alamat' => 'Jalan Raya Bandung No. 456',
                'provinsi' => 'Jawa Barat',
                'kabupaten' => 'Bandung',
                'kecamatan' => 'Bandung Wetan',
                'desa' => 'Citarum',
                'kode_pos' => '40115',
                'nomor_telepon' => '022-7654321',
                'email' => 'wim.bandung@hubnet.go.id',
                'penanggung_jawab' => 'Ir. Siti Aminah',
                'is_sent_to_hubnet' => false,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id_wim' => 'WIM003',
                'nama_lokasi' => 'Pos WIM Surabaya',
                'tipe' => 'Fixed WIM',
                'dimensi' => '3.5m x 20m',
                'tahun_pembuatan' => 2019,
                'kondisi' => 'Baik',
                'keterangan' => 'Pos WIM permanen di Jalan Raya Surabaya',
                'status' => 'aktif',
                'latitude' => -7.2575,
                'longitude' => 112.7521,
                'alamat' => 'Jalan Raya Surabaya No. 789',
                'provinsi' => 'Jawa Timur',
                'kabupaten' => 'Surabaya',
                'kecamatan' => 'Gubeng',
                'desa' => 'Gubeng',
                'kode_pos' => '60281',
                'nomor_telepon' => '031-9876543',
                'email' => 'wim.surabaya@hubnet.go.id',
                'penanggung_jawab' => 'Ir. Ahmad Hidayat',
                'is_sent_to_hubnet' => false,
                'created_at' => now(),
                'updated_at' => now(),
            ]
        ]);

        // Seed WIM Log data
        DB::table('wim_log')->insert([
            [
                'id_wim' => 'WIM001',
                'no_kendaraan' => 'B1234ABC',
                'jenis_kendaraan' => 'Truck',
                'merk_kendaraan' => 'Mitsubishi',
                'model_kendaraan' => 'Fuso',
                'warna_kendaraan' => 'Putih',
                'tahun_kendaraan' => '2018',
                'nomor_rangka' => 'MHFU28F1234567890',
                'nomor_mesin' => '4M40-1234567',
                'nama_pengemudi' => 'Budi Santoso',
                'nomor_sim' => '1234567890',
                'alamat_pengemudi' => 'Jl. Sudirman No. 123, Jakarta',
                'nama_perusahaan' => 'PT Angkutan Barang Maju',
                'alamat_perusahaan' => 'Jl. Gatot Subroto No. 456, Jakarta',
                'nomor_izin' => 'SIUP-123456789',
                'jenis_izin' => 'Angkutan Barang',
                'rute' => 'Jakarta-Bandung',
                'asal' => 'Jakarta',
                'tujuan' => 'Bandung',
                'jenis_barang' => 'Elektronik',
                'berat_kosong' => 8.5,
                'berat_muatan' => 12.3,
                'berat_total' => 20.8,
                'berat_1_axle' => 6.2,
                'berat_2_axle' => 7.8,
                'berat_3_axle' => 6.8,
                'kecepatan' => 45.5,
                'jarak_axle' => 4.2,
                'status_penimbangan' => 'berhasil',
                'catatan' => 'Kendaraan dalam kondisi baik',
                'operator' => 'Operator 1',
                'shift' => 'Pagi',
                'kondisi_cuaca' => 'Cerah',
                'kondisi_jalan' => 'Kering',
                'is_overload' => false,
                'overload_persen' => null,
                'overload_berat' => null,
                'tindakan_overload' => null,
                'is_sent_to_hubnet' => false,
                'sent_to_hubnet_at' => null,
                'waktu_penimbangan' => now()->subHours(2),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id_wim' => 'WIM001',
                'no_kendaraan' => 'B5678DEF',
                'jenis_kendaraan' => 'Truck',
                'merk_kendaraan' => 'Hino',
                'model_kendaraan' => 'Ranger',
                'warna_kendaraan' => 'Merah',
                'tahun_kendaraan' => '2019',
                'nomor_rangka' => 'HINO1234567890123',
                'nomor_mesin' => 'J08E-1234567',
                'nama_pengemudi' => 'Siti Aminah',
                'nomor_sim' => '0987654321',
                'alamat_pengemudi' => 'Jl. Thamrin No. 789, Jakarta',
                'nama_perusahaan' => 'PT Logistik Cepat',
                'alamat_perusahaan' => 'Jl. Sudirman No. 321, Jakarta',
                'nomor_izin' => 'SIUP-987654321',
                'jenis_izin' => 'Angkutan Barang',
                'rute' => 'Jakarta-Surabaya',
                'asal' => 'Jakarta',
                'tujuan' => 'Surabaya',
                'jenis_barang' => 'Makanan',
                'berat_kosong' => 7.8,
                'berat_muatan' => 15.2,
                'berat_total' => 23.0,
                'berat_1_axle' => 7.5,
                'berat_2_axle' => 8.2,
                'berat_3_axle' => 7.3,
                'kecepatan' => 42.0,
                'jarak_axle' => 4.0,
                'status_penimbangan' => 'berhasil',
                'catatan' => 'Kendaraan overload, perlu tindakan',
                'operator' => 'Operator 2',
                'shift' => 'Siang',
                'kondisi_cuaca' => 'Berawan',
                'kondisi_jalan' => 'Basah',
                'is_overload' => true,
                'overload_persen' => 15.2,
                'overload_berat' => 3.0,
                'tindakan_overload' => 'Dilakukan pemeriksaan lanjutan',
                'is_sent_to_hubnet' => false,
                'sent_to_hubnet_at' => null,
                'waktu_penimbangan' => now()->subHours(1),
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'id_wim' => 'WIM002',
                'no_kendaraan' => 'D9012GHI',
                'jenis_kendaraan' => 'Truck',
                'merk_kendaraan' => 'Isuzu',
                'model_kendaraan' => 'Elf',
                'warna_kendaraan' => 'Biru',
                'tahun_kendaraan' => '2020',
                'nomor_rangka' => 'ISUZU123456789012',
                'nomor_mesin' => '4HK1-1234567',
                'nama_pengemudi' => 'Ahmad Hidayat',
                'nomor_sim' => '1122334455',
                'alamat_pengemudi' => 'Jl. Asia Afrika No. 111, Bandung',
                'nama_perusahaan' => 'PT Distribusi Bandung',
                'alamat_perusahaan' => 'Jl. Cihampelas No. 222, Bandung',
                'nomor_izin' => 'SIUP-112233445',
                'jenis_izin' => 'Angkutan Barang',
                'rute' => 'Bandung-Jakarta',
                'asal' => 'Bandung',
                'tujuan' => 'Jakarta',
                'jenis_barang' => 'Tekstil',
                'berat_kosong' => 6.5,
                'berat_muatan' => 8.7,
                'berat_total' => 15.2,
                'berat_1_axle' => 5.8,
                'berat_2_axle' => 5.4,
                'berat_3_axle' => 4.0,
                'kecepatan' => 48.0,
                'jarak_axle' => 3.8,
                'status_penimbangan' => 'berhasil',
                'catatan' => 'Kendaraan dalam batas normal',
                'operator' => 'Operator 3',
                'shift' => 'Pagi',
                'kondisi_cuaca' => 'Cerah',
                'kondisi_jalan' => 'Kering',
                'is_overload' => false,
                'overload_persen' => null,
                'overload_berat' => null,
                'tindakan_overload' => null,
                'is_sent_to_hubnet' => false,
                'sent_to_hubnet_at' => null,
                'waktu_penimbangan' => now()->subMinutes(30),
                'created_at' => now(),
                'updated_at' => now(),
            ]
        ]);

        $this->command->info('WIM data seeded successfully!');
    }
} 