<?php

// Debug script for POST-Only Receiver API
echo "=== POST-Only Receiver Debug ===\n";

// Check if we can connect to database
try {
    $pdo = new PDO("mysql:host=127.0.0.1;dbname=copg1493_api", "copg1493_api", "P7H_s;Aco25Vv??J");
    echo "✅ Database connection successful\n";
} catch (PDOException $e) {
    echo "❌ Database connection failed: " . $e->getMessage() . "\n";
    exit(1);
}

// Check if post_only_receivers table exists
try {
    $stmt = $pdo->query("SHOW TABLES LIKE 'post_only_receivers'");
    if ($stmt->rowCount() > 0) {
        echo "✅ post_only_receivers table exists\n";
    } else {
        echo "❌ post_only_receivers table does not exist\n";
    }
} catch (PDOException $e) {
    echo "❌ Error checking table: " . $e->getMessage() . "\n";
}

// Check if any receivers exist
try {
    $stmt = $pdo->query("SELECT id, name, endpoint, is_active FROM post_only_receivers");
    $receivers = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($receivers)) {
        echo "❌ No receivers found in database\n";
    } else {
        echo "✅ Found " . count($receivers) . " receivers:\n";
        foreach ($receivers as $receiver) {
            $status = $receiver['is_active'] ? 'Active' : 'Inactive';
            echo "  - ID: {$receiver['id']}, Name: {$receiver['name']}, Endpoint: {$receiver['endpoint']}, Status: {$status}\n";
        }
    }
} catch (PDOException $e) {
    echo "❌ Error fetching receivers: " . $e->getMessage() . "\n";
}

// Check specific endpoint
$endpoint = 'modern-receiver-568';
try {
    $stmt = $pdo->prepare("SELECT * FROM post_only_receivers WHERE endpoint = ? AND is_active = 1");
    $stmt->execute([$endpoint]);
    $receiver = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($receiver) {
        echo "✅ Found active receiver for endpoint '{$endpoint}':\n";
        echo "  - Name: {$receiver['name']}\n";
        echo "  - Target Table: {$receiver['target_table']}\n";
        echo "  - Require Token: " . ($receiver['require_token'] ? 'Yes' : 'No') . "\n";
        echo "  - API Client ID: " . ($receiver['api_client_id'] ?? 'None') . "\n";
    } else {
        echo "❌ No active receiver found for endpoint '{$endpoint}'\n";
        
        // Try to create one
        echo "📝 Creating receiver for '{$endpoint}'...\n";
        $stmt = $pdo->prepare("
            INSERT INTO post_only_receivers (
                name, endpoint, target_table, description, 
                require_token, is_active, auto_create_table,
                rate_limit, total_received, total_success, total_failed,
                sample_data, created_at, updated_at
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW())
        ");
        
        $sampleData = json_encode([
            'user_id' => 123,
            'event_type' => 'test_event',
            'data' => [
                'message' => 'Test message',
                'timestamp' => '2025-01-23T10:30:00Z'
            ],
            'source' => 'debug_script'
        ]);
        
        $result = $stmt->execute([
            'Modern Receiver Test',
            $endpoint,
            'modern_receiver_data',
            'Auto-created receiver for testing modern-receiver-568 endpoint',
            0, // No token required for testing
            1, // Active
            1, // Auto create table
            1000, // Rate limit
            0, 0, 0, // Counters
            $sampleData
        ]);
        
        if ($result) {
            echo "✅ Receiver for '{$endpoint}' created successfully\n";
            
            // Get the created receiver info
            $stmt = $pdo->prepare("SELECT * FROM post_only_receivers WHERE endpoint = ?");
            $stmt->execute([$endpoint]);
            $receiver = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if ($receiver) {
                echo "  - ID: {$receiver['id']}\n";
                echo "  - Name: {$receiver['name']}\n";
                echo "  - Target Table: {$receiver['target_table']}\n";
                echo "  - Require Token: " . ($receiver['require_token'] ? 'Yes' : 'No') . "\n";
            }
        } else {
            echo "❌ Failed to create receiver for '{$endpoint}'\n";
        }
    }
} catch (PDOException $e) {
    echo "❌ Error checking/creating receiver: " . $e->getMessage() . "\n";
}

// Test the API endpoint
echo "\n=== Testing API Endpoint ===\n";
$apiUrl = 'https://copilotproduction.site/api/post/' . $endpoint;
echo "Testing URL: {$apiUrl}\n";

$testData = [
    'test_field' => 'test_value',
    'timestamp' => date('Y-m-d H:i:s'),
    'source' => 'debug_script'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($testData));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Accept: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_VERBOSE, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "HTTP Code: {$httpCode}\n";
if ($error) {
    echo "cURL Error: {$error}\n";
}

echo "Response:\n";
echo $response . "\n";

// Check if response is JSON
$jsonData = json_decode($response, true);
if (json_last_error() === JSON_ERROR_NONE) {
    echo "✅ Response is valid JSON\n";
    print_r($jsonData);
} else {
    echo "❌ Response is not valid JSON\n";
    echo "JSON Error: " . json_last_error_msg() . "\n";
    
    // Check if it's HTML
    if (strpos($response, '<!DOCTYPE') !== false || strpos($response, '<html') !== false) {
        echo "❌ Response appears to be HTML (likely an error page)\n";
        
        // Extract title if possible
        if (preg_match('/<title>(.*?)<\/title>/i', $response, $matches)) {
            echo "Page Title: " . $matches[1] . "\n";
        }
    }
}

echo "\n=== Debug Complete ===\n"; 