<?php
// Debug routes script
// This script will check if the import route is registered

require_once __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);

$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

// Get all registered routes
$routes = app('router')->getRoutes();

echo "<h2>Laravel Routes Debug</h2>";
echo "<h3>Looking for api-sources import route...</h3>";

$found = false;
foreach ($routes as $route) {
    $uri = $route->uri();
    $methods = implode('|', $route->methods());
    
    if (strpos($uri, 'api-sources') !== false && strpos($uri, 'import') !== false) {
        echo "<p style='color: green;'><strong>FOUND:</strong> $methods $uri</p>";
        $found = true;
    }
}

if (!$found) {
    echo "<p style='color: red;'><strong>NOT FOUND:</strong> api-sources import route not registered</p>";
}

echo "<h3>All api-sources routes:</h3>";
foreach ($routes as $route) {
    $uri = $route->uri();
    $methods = implode('|', $route->methods());
    
    if (strpos($uri, 'api-sources') !== false) {
        echo "<p>$methods $uri</p>";
    }
}

echo "<h3>Cache Information:</h3>";
echo "<p>Routes cached: " . (file_exists(__DIR__ . '/bootstrap/cache/routes.php') ? 'YES' : 'NO') . "</p>";
echo "<p>Config cached: " . (file_exists(__DIR__ . '/bootstrap/cache/config.php') ? 'YES' : 'NO') . "</p>";

$kernel->terminate($request, $response);
?> 