<?php

// Debug Basic Auth untuk endpoint /api/in/baden
$url = 'https://copilotproduction.site/api/in/baden';
$username = 'baden';
$password = 'baden';

// Encode credentials untuk Basic Auth
$credentials = base64_encode($username . ':' . $password);

echo "=== Debug Basic Auth ===\n";
echo "URL: $url\n";
echo "Username: '$username'\n";
echo "Password: '$password'\n";
echo "Raw credentials: '$username:$password'\n";
echo "Encoded credentials: '$credentials'\n";
echo "Full Authorization header: 'Basic $credentials'\n\n";

// Test 1: Tanpa Authorization header
echo "=== Test 1: Tanpa Authorization Header ===\n";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['test' => 'data']));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Accept: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
echo "Response: $response\n\n";

// Test 2: Dengan Authorization header yang benar
echo "=== Test 2: Dengan Authorization Header ===\n";
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['test' => 'data']));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Authorization: Basic ' . $credentials,
    'Content-Type: application/json',
    'Accept: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
echo "Response: $response\n\n";

// Test 3: Decode credentials untuk verifikasi
echo "=== Test 3: Verifikasi Encoding ===\n";
$decoded = base64_decode($credentials);
echo "Encoded: $credentials\n";
echo "Decoded: '$decoded'\n";
echo "Expected: '$username:$password'\n";
echo "Match: " . ($decoded === "$username:$password" ? 'YES' : 'NO') . "\n\n";

// Test 4: Coba dengan credentials yang berbeda
echo "=== Test 4: Test dengan credentials manual ===\n";
$manualCredentials = base64_encode('baden:baden');
echo "Manual encoded: $manualCredentials\n";
echo "Original encoded: $credentials\n";
echo "Match: " . ($manualCredentials === $credentials ? 'YES' : 'NO') . "\n\n";

// Test 5: Coba dengan header yang berbeda
echo "=== Test 5: Test dengan format header berbeda ===\n";
$headers = [
    'Authorization: Basic ' . $credentials,
    'Content-Type: application/json',
    'Accept: application/json',
    'User-Agent: Debug-Test/1.0'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(['test' => 'data']));
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_VERBOSE, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "HTTP Code: $httpCode\n";
echo "Response: $response\n\n";

echo "=== Debug selesai ===\n";
