<?php
/**
 * Debug Response Test
 */

// Konfigurasi
$url = 'https://your-domain.com/api/in/test-receiver'; // Ganti dengan URL Anda

echo "🔍 Debug Response Test\n";
echo "URL: {$url}\n\n";

// Test request
$body = ['data' => 'customer'];

echo "📤 Request Body: " . json_encode($body) . "\n\n";

// Lakukan request
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($body));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Accept: application/json'
]);
curl_setopt($ch, CURLOPT_VERBOSE, true);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
$info = curl_getinfo($ch);
curl_close($ch);

echo "📡 HTTP Code: {$httpCode}\n";
echo "📡 Content Type: " . $info['content_type'] . "\n";
echo "📡 Response Size: " . strlen($response) . " bytes\n\n";

if ($error) {
    echo "❌ CURL Error: {$error}\n";
} else {
    echo "📄 Raw Response:\n";
    echo $response . "\n\n";
    
    echo "📄 Parsed Response:\n";
    $responseData = json_decode($response, true);
    if ($responseData) {
        echo json_encode($responseData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n\n";
        
        // Check format
        if (isset($responseData['sukses'])) {
            echo "✅ Format Check: Response menggunakan 'sukses' ✓\n";
            if ($responseData['sukses'] === true) {
                if (isset($responseData['datas'])) {
                    echo "✅ Data Check: Response memiliki 'datas' ✓\n";
                    echo "📊 Data Count: " . count($responseData['datas']) . "\n";
                } else {
                    echo "❌ Data Check: Response tidak memiliki 'datas'\n";
                }
            } else {
                echo "❌ Success Check: Response sukses = false\n";
            }
        } else {
            echo "❌ Format Check: Response tidak menggunakan 'sukses'\n";
        }
    } else {
        echo "❌ JSON Parse Error: " . json_last_error_msg() . "\n";
    }
}

echo "\n🔍 Debug Info:\n";
echo "Request URL: {$url}\n";
echo "Request Method: GET\n";
echo "Request Headers: Content-Type: application/json, Accept: application/json\n";
echo "Request Body: " . json_encode($body) . "\n";
?>
