<?php
// Laravel API Deployment Test
// File: deployment-test.php
// Purpose: Test server PHP environment and basic functionality

echo "<h1>Laravel API Deployment Test</h1>";
echo "<h2>Server Information</h2>";

// PHP Version
echo "<p><strong>PHP Version:</strong> " . phpversion() . "</p>";

// Server Info
echo "<p><strong>Server:</strong> " . $_SERVER['SERVER_SOFTWARE'] . "</p>";
echo "<p><strong>Document Root:</strong> " . $_SERVER['DOCUMENT_ROOT'] . "</p>";
echo "<p><strong>Current Directory:</strong> " . getcwd() . "</p>";

// Required Extensions Check
echo "<h2>Required PHP Extensions</h2>";
$required_extensions = [
    'pdo',
    'pdo_mysql',
    'mbstring',
    'tokenizer',
    'xml',
    'ctype',
    'json',
    'bcmath',
    'curl',
    'fileinfo',
    'openssl'
];

echo "<ul>";
foreach ($required_extensions as $ext) {
    $status = extension_loaded($ext) ? "✅ Installed" : "❌ Missing";
    echo "<li><strong>$ext:</strong> $status</li>";
}
echo "</ul>";

// File Permissions Test
echo "<h2>File Permissions Test</h2>";
$test_file = 'permission_test.txt';
if (file_put_contents($test_file, 'Test write permission')) {
    echo "<p>✅ Write permission: OK</p>";
    unlink($test_file);
} else {
    echo "<p>❌ Write permission: FAILED</p>";
}

// Memory Limit
echo "<h2>Server Configuration</h2>";
echo "<p><strong>Memory Limit:</strong> " . ini_get('memory_limit') . "</p>";
echo "<p><strong>Max Execution Time:</strong> " . ini_get('max_execution_time') . " seconds</p>";
echo "<p><strong>Upload Max Filesize:</strong> " . ini_get('upload_max_filesize') . "</p>";
echo "<p><strong>Post Max Size:</strong> " . ini_get('post_max_size') . "</p>";

// Test Database Connection (if credentials available)
echo "<h2>Database Connection Test</h2>";
echo "<p><em>Database test will be performed after .env configuration</em></p>";

echo "<h2>Next Steps</h2>";
echo "<ol>";
echo "<li>Upload Laravel project files</li>";
echo "<li>Create .env file with database credentials</li>";
echo "<li>Run composer install</li>";
echo "<li>Set up database and run migrations</li>";
echo "<li>Configure web server (if needed)</li>";
echo "</ol>";

echo "<hr>";
echo "<p><small>Test completed at: " . date('Y-m-d H:i:s') . "</small></p>";
echo "<p><small>Delete this file after deployment is complete</small></p>";
?> 