<?php

// Direct fix untuk masalah Basic Auth
// Jalankan file ini di hosting untuk memperbaiki masalah secara langsung

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;

try {
    echo "=== DIRECT FIX BASIC AUTH ===\n";
    
    // 1. Cek dan perbaiki receiver
    $receiver = DB::table('api_receivers')->where('endpoint', 'baden')->first();
    
    if ($receiver) {
        echo "✅ Receiver 'baden' ditemukan\n";
        echo "ID: {$receiver->id}\n";
        echo "Current Auth Type: {$receiver->auth_type}\n";
        echo "Current Username: " . ($receiver->auth_username ?? 'NULL') . "\n";
        echo "Current Password: " . ($receiver->auth_password ?? 'NULL') . "\n";
        
        // Force update dengan nilai yang benar
        $updated = DB::table('api_receivers')
            ->where('endpoint', 'baden')
            ->update([
                'auth_type' => 'basic_auth',
                'auth_username' => 'baden',
                'auth_password' => 'baden',
                'is_active' => 1,
                'allowed_methods' => 'GET,POST,PUT,DELETE',
                'updated_at' => now()
            ]);
        
        if ($updated) {
            echo "✅ Receiver berhasil diupdate!\n";
        } else {
            echo "❌ Gagal mengupdate receiver\n";
        }
        
    } else {
        echo "❌ Receiver 'baden' tidak ditemukan\n";
        echo "Membuat receiver baru...\n";
        
        $newId = DB::table('api_receivers')->insertGetId([
            'name' => 'Baden Basic Auth Receiver',
            'description' => 'Receiver for Baden System with Basic Authentication',
            'endpoint' => 'baden',
            'target_table' => 'orders',
            'auth_type' => 'basic_auth',
            'auth_username' => 'baden',
            'auth_password' => 'baden',
            'allowed_methods' => 'GET,POST,PUT,DELETE',
            'rate_limit' => 100,
            'auto_create_table' => 1,
            'is_active' => 1,
            'is_bidirectional' => 1,
            'duplicate_handling' => 'update',
            'unique_fields' => 'order_id',
            'data_filter' => 'all',
            'max_records_per_request' => 100,
            'enable_scheduling' => 1,
            'schedule_type' => 'interval',
            'schedule_interval' => 5,
            'timezone' => 'Asia/Jakarta',
            'response_format' => 'json',
            'auto_acknowledge' => 1,
            'retry_attempts' => 3,
            'retry_delay' => 60,
            'validation_rules' => json_encode([
                'order_id' => ['required' => true, 'type' => 'string'],
                'customer_name' => ['required' => true, 'type' => 'string'],
                'total_amount' => ['required' => true, 'type' => 'numeric']
            ]),
            'created_at' => now(),
            'updated_at' => now()
        ]);
        
        echo "✅ Receiver baru berhasil dibuat dengan ID: $newId\n";
    }
    
    // 2. Verifikasi update
    $updatedReceiver = DB::table('api_receivers')->where('endpoint', 'baden')->first();
    
    if ($updatedReceiver) {
        echo "\n=== VERIFIKASI KONFIGURASI ===\n";
        echo "ID: {$updatedReceiver->id}\n";
        echo "Auth Type: {$updatedReceiver->auth_type}\n";
        echo "Username: {$updatedReceiver->auth_username}\n";
        echo "Password: {$updatedReceiver->auth_password}\n";
        echo "Is Active: " . ($updatedReceiver->is_active ? 'Yes' : 'No') . "\n";
        
        // 3. Test Basic Auth logic
        echo "\n=== TEST BASIC AUTH LOGIC ===\n";
        
        $testUsername = 'baden';
        $testPassword = 'baden';
        $authHeader = 'Basic ' . base64_encode($testUsername . ':' . $testPassword);
        
        echo "Test Username: '$testUsername'\n";
        echo "Test Password: '$testPassword'\n";
        echo "Auth Header: '$authHeader'\n";
        
        // Simulasi proses autentikasi
        if (str_starts_with($authHeader, 'Basic ')) {
            $credentials = base64_decode(substr($authHeader, 6));
            $parts = explode(':', $credentials, 2);
            
            if (count($parts) === 2) {
                $username = $parts[0];
                $password = $parts[1];
                
                echo "Extracted Username: '$username'\n";
                echo "Extracted Password: '$password'\n";
                echo "Stored Username: '{$updatedReceiver->auth_username}'\n";
                echo "Stored Password: '{$updatedReceiver->auth_password}'\n";
                
                $usernameMatch = $username === $updatedReceiver->auth_username;
                $passwordMatch = $password === $updatedReceiver->auth_password;
                
                echo "Username Match: " . ($usernameMatch ? 'YES' : 'NO') . "\n";
                echo "Password Match: " . ($passwordMatch ? 'YES' : 'NO') . "\n";
                
                if ($usernameMatch && $passwordMatch) {
                    echo "✅ Basic Auth Logic BERHASIL!\n";
                } else {
                    echo "❌ Basic Auth Logic GAGAL!\n";
                }
            }
        }
        
        // 4. Test dengan cURL
        echo "\n=== TEST DENGAN CURL ===\n";
        
        $url = 'https://copilotproduction.site/api/in/baden';
        $credentials = base64_encode('baden:baden');
        $headers = [
            'Authorization: Basic ' . $credentials,
            'Content-Type: application/json',
            'Accept: application/json'
        ];
        
        $data = json_encode(['test' => 'data']);
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        curl_close($ch);
        
        echo "URL: $url\n";
        echo "Headers: " . implode(', ', $headers) . "\n";
        echo "Data: $data\n";
        echo "HTTP Code: $httpCode\n";
        
        if ($error) {
            echo "cURL Error: $error\n";
        }
        
        echo "Response: $response\n";
        
        if ($httpCode === 200 || $httpCode === 201) {
            echo "✅ CURL TEST BERHASIL!\n";
        } else {
            echo "❌ CURL TEST GAGAL!\n";
        }
        
        // 5. Instruksi untuk user
        echo "\n=== INSTRUKSI PENGGUNAAN ===\n";
        echo "Sekarang gunakan kredensial berikut di Postman/API Client:\n";
        echo "URL: https://copilotproduction.site/api/in/baden\n";
        echo "Method: POST\n";
        echo "Auth Type: Basic Auth\n";
        echo "Username: baden\n";
        echo "Password: baden\n";
        echo "Authorization Header: Basic $credentials\n";
        echo "Content-Type: application/json\n";
        echo "Body: {\"test\": \"data\"}\n";
        
    } else {
        echo "❌ Gagal memverifikasi receiver\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
