# API Sources - Sistem GET & POST

## Overview
API Sources telah diperbarui untuk mendukung **dua metode HTTP**:
- **GET**: Mengambil data dari API eksternal → Simpan ke database lokal
- **POST**: Mengirim data dari database lokal → Kirim ke API eksternal

## Fitur Dual Method

### 🔄 **GET Method - Data Fetcher**
- **Fungsi**: Mengambil data dari API eksternal
- **Proses**: External API → Database Lokal
- **Use Case**: Import data, sync dari sumber eksternal
- **Button**: "Ambil Data" dengan icon download

### 📤 **POST Method - Data Sender**
- **Fungsi**: Mengirim data ke API eksternal
- **Proses**: Database Lokal → External API
- **Use Case**: Export data, push ke sistem eksternal
- **Button**: "Kirim Data" dengan icon paper-plane

## Cara Kerja

### 1. **GET Operation (Data Fetching)**
```http
GET https://api.external.com/users
Authorization: Bearer token123
```

**Response dari API Eksternal:**
```json
[
  {"id": 1, "name": "John", "email": "john@example.com"},
  {"id": 2, "name": "Jane", "email": "jane@example.com"}
]
```

**Disimpan ke tabel lokal** yang ditentukan di `table_name`

### 2. **POST Operation (Data Sending)**
```http
POST https://api.external.com/receive-data
Authorization: Bearer token123
Content-Type: application/json

{
  "source_table": "users",
  "data": [
    {"id": 1, "name": "Admin", "email": "admin@local.com"},
    {"id": 2, "name": "User", "email": "user@local.com"}
  ],
  "timestamp": "2025-07-05T12:14:47Z",
  "source_name": "User Data Export"
}
```

## Interface Updates

### **Form Configuration**
- **Method Dropdown**: GET | POST
- **Dynamic Help Text**: Berubah sesuai method yang dipilih
- **Smart Labels**: Context-aware berdasarkan operation type

### **Help Text Context-Aware**
```
API URL:
- GET: URL API sumber untuk mengambil data
- POST: URL API tujuan untuk mengirim data

Table Name:
- GET: Tabel tujuan untuk menyimpan data yang diambil
- POST: Tabel sumber data yang akan dikirim
```

### **Button Labels**
- **GET**: "Ambil Data" (Download icon)
- **POST**: "Kirim Data" (Send icon)

## Authentication Support

### **Bearer Token**
```http
Authorization: Bearer your-token-here
```

### **API Key**
```http
X-API-Key: your-api-key-here
```

### **None**
No authentication headers

## Logging & Monitoring

### **GET Logs**
```json
{
  "method": "GET",
  "status": "success",
  "records_imported": 25,
  "message": "Data berhasil diambil dari API"
}
```

### **POST Logs**
```json
{
  "method": "POST", 
  "status": "success",
  "records_imported": 15,
  "message": "Data berhasil dikirim ke API"
}
```

## Test Connection

### **GET Test**
- Melakukan GET request ke URL
- Verifikasi response status
- Cek authentication
- Message: "Koneksi API berhasil untuk pengambilan data"

### **POST Test**
- Mengirim sample data via POST
- Test authentication headers
- Verifikasi endpoint menerima data
- Message: "Koneksi API berhasil untuk pengiriman data"

## Use Cases

### **Scenario 1: Data Import (GET)**
```
Name: User Import from CRM
Method: GET
URL: https://crm.company.com/api/users
Table: imported_users
Auth: Bearer token
Schedule: Daily
```

### **Scenario 2: Data Export (POST)**
```
Name: Sales Data Export
Method: POST  
URL: https://analytics.company.com/api/receive
Table: sales_data
Auth: API Key
Schedule: Hourly
```

### **Scenario 3: Two-Way Sync**
```
API Source 1 (GET): Import orders from e-commerce
API Source 2 (POST): Send inventory updates to e-commerce
```

## Migration & Database

### **Schema Update**
```sql
ALTER TABLE api_sources 
MODIFY COLUMN method ENUM('GET', 'POST') DEFAULT 'GET';
```

### **Backward Compatibility**
- Existing POST-only sources tetap berfungsi
- GET method sebagai default untuk sources baru
- Migration otomatis update schema

## Error Handling

### **GET Errors**
- "Pengambilan gagal: Connection timeout"
- "Pengambilan gagal: Invalid response format"
- "Pengambilan gagal: Authentication failed"

### **POST Errors**
- "Pengiriman gagal: Endpoint not found"
- "Pengiriman gagal: Data validation error"
- "Pengiriman gagal: Rate limit exceeded"

## Best Practices

### **GET Operations**
1. Set appropriate timeout (30s recommended)
2. Handle large datasets with pagination
3. Validate data format before saving
4. Monitor API rate limits

### **POST Operations**
1. Batch data appropriately (avoid huge payloads)
2. Implement retry logic for failed sends
3. Validate data before sending
4. Monitor response status codes

### **Security**
1. Use HTTPS URLs only
2. Store tokens securely
3. Implement rate limiting
4. Log all operations for audit

## API Response Formats

### **Success Response**
```json
{
  "success": true,
  "message": "Data berhasil diambil/dikirim",
  "records": 25,
  "method": "GET|POST"
}
```

### **Error Response**
```json
{
  "success": false,
  "message": "Detailed error message",
  "error_code": "TIMEOUT|AUTH_FAILED|INVALID_DATA"
}
```

## Status: ✅ IMPLEMENTASI SELESAI

API Sources sekarang mendukung **dual method GET & POST** dengan:
- ✅ Dynamic interface berdasarkan method
- ✅ Context-aware help text
- ✅ Method-specific operations
- ✅ Smart button labels
- ✅ Comprehensive logging
- ✅ Authentication support
- ✅ Error handling

Sistem memberikan fleksibilitas penuh untuk operasi **data fetching (GET)** dan **data sending (POST)** dalam satu interface yang unified. 