# API Transceiver Documentation

## Overview
API Transceiver adalah modul yang memungkinkan komunikasi dua arah antara sistem, memungkinkan pengiriman dan penerimaan data secara otomatis. Modul ini mendukung berbagai metode penjadwalan, penanganan kesalahan, dan pemantauan.

## Base URL
```
http://127.0.0.1:8000
```

## Authentication
Semua endpoint memerlukan autentikasi. Gunakan salah satu metode berikut:
- Session-based authentication (untuk akses via browser)
- API Token (untuk akses via API)

## Endpoints

### 1. List Transceivers
Menampilkan daftar semua transceivers.

```
GET /api-transceivers
```

**Response Format:**
```json
{
    "data": [
        {
            "id": 1,
            "name": "Sample Transceiver",
            "api_client_id": 1,
            "api_receiver_id": 1,
            "api_target_id": 1,
            "direction": "bidirectional",
            "schedule_type": "interval",
            "sync_interval": 60,
            "is_active": true,
            "created_at": "2024-01-01T00:00:00Z",
            "updated_at": "2024-01-01T00:00:00Z"
        }
    ],
    "links": {
        "first": "http://127.0.0.1:8000/api-transceivers?page=1",
        "last": "http://127.0.0.1:8000/api-transceivers?page=1",
        "prev": null,
        "next": null
    },
    "meta": {
        "current_page": 1,
        "from": 1,
        "last_page": 1,
        "path": "http://127.0.0.1:8000/api-transceivers",
        "per_page": 10,
        "to": 1,
        "total": 1
    }
}
```

### 2. Create New Transceiver
Membuat transceiver baru.

```
POST /api-transceivers
```

**Request Body:**
```json
{
    "name": "New Transceiver",
    "api_client_id": 1,
    "api_receiver_id": 1,
    "api_target_id": 1,
    "direction": "bidirectional",
    "schedule_type": "interval",
    "sync_interval": 60,
    "cron_expression": null,
    "description": "Sample description",
    "is_active": true,
    "auto_sync": true
}
```

**Required Fields:**
- `name`: string (max 255 chars)
- `api_client_id`: integer (valid client ID)
- `api_receiver_id`: integer (valid receiver ID)
- `api_target_id`: integer (valid target ID)
- `direction`: string (unidirectional/bidirectional)
- `schedule_type`: string (manual/interval/cron)

**Optional Fields:**
- `sync_interval`: integer (1-1440, required if schedule_type is interval)
- `cron_expression`: string (required if schedule_type is cron)
- `description`: string
- `is_active`: boolean
- `auto_sync`: boolean

### 3. Show Transceiver Details
Menampilkan detail transceiver tertentu.

```
GET /api-transceivers/{id}
```

**Response Format:**
```json
{
    "data": {
        "id": 1,
        "name": "Sample Transceiver",
        "api_client_id": 1,
        "api_receiver_id": 1,
        "api_target_id": 1,
        "direction": "bidirectional",
        "schedule_type": "interval",
        "sync_interval": 60,
        "cron_expression": null,
        "description": "Sample description",
        "is_active": true,
        "auto_sync": true,
        "created_at": "2024-01-01T00:00:00Z",
        "updated_at": "2024-01-01T00:00:00Z",
        "api_client": {
            "id": 1,
            "name": "Client Name"
        },
        "receiver": {
            "id": 1,
            "name": "Receiver Name"
        },
        "target": {
            "id": 1,
            "name": "Target Name"
        }
    }
}
```

### 4. Update Transceiver
Mengupdate data transceiver yang ada.

```
PUT/PATCH /api-transceivers/{id}
```

**Request Body:** (sama seperti Create)

### 5. Delete Transceiver
Menghapus transceiver.

```
DELETE /api-transceivers/{id}
```

### 6. Test Transceiver
Menguji koneksi transceiver.

```
POST /api-transceivers/{id}/test
```

**Response Format:**
```json
{
    "success": true,
    "message": "Test completed successfully"
}
```

### 7. Toggle Status
Mengaktifkan/menonaktifkan transceiver.

```
POST /api-transceivers/{id}/toggle-status
```

**Response Format:**
```json
{
    "success": true,
    "message": "Status updated successfully",
    "is_active": true
}
```

### 8. View Logs
Menampilkan log aktivitas transceiver.

```
GET /api-transceivers/{id}/logs
```

**Response Format:**
```json
{
    "data": [
        {
            "id": 1,
            "api_transceiver_id": 1,
            "status": "success",
            "message": "Data synced successfully",
            "records_processed": 100,
            "execution_time": 2.5,
            "created_at": "2024-01-01T00:00:00Z"
        }
    ],
    "meta": {
        "current_page": 1,
        "from": 1,
        "last_page": 1,
        "path": "http://127.0.0.1:8000/api-transceivers/1/logs",
        "per_page": 20,
        "to": 1,
        "total": 1
    }
}
```

### 9. Sync Data
Memulai sinkronisasi data manual.

```
POST /api-transceivers/{id}/sync
```

**Response Format:**
```json
{
    "success": true,
    "message": "Sync started successfully"
}
```

## Error Handling

Semua endpoint akan mengembalikan response error dalam format berikut:

```json
{
    "success": false,
    "error": "Error message description",
    "details": {
        "field_name": ["Error message for specific field"]
    }
}
```

**Common HTTP Status Codes:**
- 200: Success
- 201: Created
- 400: Bad Request
- 401: Unauthorized
- 403: Forbidden
- 404: Not Found
- 422: Validation Error
- 500: Server Error

## Scheduling Types

1. **Manual**
   - Sinkronisasi hanya dilakukan melalui endpoint sync
   - Tidak ada jadwal otomatis

2. **Interval**
   - `sync_interval`: Interval dalam menit (1-1440)
   - Sinkronisasi dilakukan secara otomatis setiap interval

3. **Cron**
   - `cron_expression`: Format cron standard
   - Contoh: "0 * * * *" (setiap jam)

## Direction Types

1. **Unidirectional**
   - Data hanya mengalir satu arah
   - Dari receiver ke target

2. **Bidirectional**
   - Data mengalir dua arah
   - Mendukung callback dan konfirmasi

## Best Practices

1. **Rate Limiting**
   - Batasi jumlah request ke endpoint sync
   - Gunakan interval yang sesuai dengan kebutuhan

2. **Error Handling**
   - Selalu periksa response status
   - Tangani error dengan tepat

3. **Monitoring**
   - Pantau logs secara berkala
   - Set up alert untuk error berulang

4. **Testing**
   - Gunakan endpoint test sebelum aktivasi
   - Validasi konfigurasi sebelum production

## Examples

### Curl Examples

1. **Create Transceiver:**
```bash
curl -X POST http://127.0.0.1:8000/api-transceivers \
  -H "Content-Type: application/json" \
  -H "Authorization: Bearer {your_token}" \
  -d '{
    "name": "New Transceiver",
    "api_client_id": 1,
    "api_receiver_id": 1,
    "api_target_id": 1,
    "direction": "bidirectional",
    "schedule_type": "interval",
    "sync_interval": 60,
    "is_active": true
  }'
```

2. **Test Transceiver:**
```bash
curl -X POST http://127.0.0.1:8000/api-transceivers/1/test \
  -H "Authorization: Bearer {your_token}"
```

3. **Sync Data:**
```bash
curl -X POST http://127.0.0.1:8000/api-transceivers/1/sync \
  -H "Authorization: Bearer {your_token}"
```

## Changelog

### Version 1.0.0
- Initial release
- Basic CRUD operations
- Scheduling support
- Bidirectional communication
- Logging system

## Support

Untuk bantuan teknis atau pertanyaan, silakan hubungi:
- Email: support@example.com
- Documentation: http://127.0.0.1:8000/docs/api-transceivers 