# PIA API HUBNET v1.0 Integration Guide

## Overview

Sistem API8 telah diintegrasikan dengan PIA API HUBNET v1.0 untuk mengirim data prasarana WIM dan log WIM secara otomatis. Integrasi ini memungkinkan sistem untuk:

1. Mengirim data prasarana WIM ke endpoint `/pu/receive-data-wim`
2. Mengirim data log WIM ke endpoint `/pu/receive-data-log-wim`
3. Menggunakan Basic Authentication
4. Menangani response dari Hubnet
5. Melacak status pengiriman data

## Konfigurasi Sistem

### 1. Database Tables

Sistem telah menyediakan dua tabel utama:

#### Tabel `wim_prasarana`
Menyimpan data prasarana WIM dengan field wajib:
- `id_wim` - ID WIM (unique)
- `nama_lokasi` - Nama lokasi WIM
- `tipe` - Tipe prasarana WIM
- `dimensi` - Dimensi prasarana
- `tahun_pembuatan` - Tahun pembuatan

#### Tabel `wim_log`
Menyimpan data log penimbangan WIM dengan field wajib:
- `id_wim` - ID WIM yang terkait
- `no_kendaraan` - Nomor kendaraan
- `berat_total` - Berat total kendaraan
- `waktu_penimbangan` - Waktu penimbangan

### 2. API Targets

Buat dua API Target untuk mengirim data ke Hubnet:

#### Target 1: Data Prasarana WIM
```
Name: Hubnet Prasarana WIM
Base URL: https://api.hubnet.go.id
Endpoint: /pu/receive-data-wim
Method: POST
Source Table: wim_prasarana
Auth Type: Basic Auth
Username: [username dari Hubnet]
Password: [password dari Hubnet]
Schedule Type: Manual/Hourly/Daily
```

#### Target 2: Data Log WIM
```
Name: Hubnet Log WIM
Base URL: https://api.hubnet.go.id
Endpoint: /pu/receive-data-log-wim
Method: POST
Source Table: wim_log
Auth Type: Basic Auth
Username: [username dari Hubnet]
Password: [password dari Hubnet]
Schedule Type: Manual/Hourly/Daily
```

## Cara Menggunakan

### 1. Setup Database

Jalankan migrasi untuk membuat tabel WIM:

```bash
php artisan migrate
```

### 2. Seed Sample Data

Jalankan seeder untuk data contoh:

```bash
php artisan db:seed --class=WimDataSeeder
```

### 3. Buat API Targets

1. Buka halaman `/api-targets/create`
2. Buat target untuk prasarana WIM:
   - Pilih "Basic Auth" sebagai authentication type
   - Masukkan username dan password dari Hubnet
   - Pilih tabel `wim_prasarana` sebagai source
   - Set endpoint `/pu/receive-data-wim`

3. Buat target untuk log WIM:
   - Pilih "Basic Auth" sebagai authentication type
   - Masukkan username dan password dari Hubnet
   - Pilih tabel `wim_log` sebagai source
   - Set endpoint `/pu/receive-data-log-wim`

### 4. Kirim Data

#### Manual Send
1. Buka halaman `/api-targets`
2. Klik tombol "Send Data" pada target yang diinginkan
3. Sistem akan mengirim data yang belum terkirim ke Hubnet

#### Automated Send
1. Set schedule type pada target (Hourly/Daily/Weekly)
2. Sistem akan mengirim data secara otomatis sesuai jadwal

### 5. Monitor Logs

Pantau status pengiriman di:
- `/api-targets/{id}/logs` - Log pengiriman per target
- `/monitoring` - Dashboard monitoring umum

## Format Data

### Data Prasarana WIM
```json
{
  "id": "WIM001",
  "nama_lokasi": "Pos WIM Jakarta Barat",
  "tipe": "Fixed WIM",
  "dimensi": "3.5m x 18m",
  "tahun_pembuatan": 2020,
  "kondisi": "Baik",
  "status": "aktif",
  "latitude": -6.2088,
  "longitude": 106.8456,
  "alamat": "Jalan Raya Jakarta Barat No. 123",
  "provinsi": "DKI Jakarta",
  "kabupaten": "Jakarta Barat",
  "kecamatan": "Grogol Petamburan",
  "desa": "Grogol",
  "kode_pos": "11450",
  "nomor_telepon": "021-1234567",
  "email": "wim.jakbar@hubnet.go.id",
  "penanggung_jawab": "Ir. Budi Santoso"
}
```

### Data Log WIM
```json
{
  "id_wim": "WIM001",
  "no_kendaraan": "B1234ABC",
  "jenis_kendaraan": "Truck",
  "merk_kendaraan": "Mitsubishi",
  "model_kendaraan": "Fuso",
  "warna_kendaraan": "Putih",
  "tahun_kendaraan": "2018",
  "nomor_rangka": "MHFU28F1234567890",
  "nomor_mesin": "4M40-1234567",
  "nama_pengemudi": "Budi Santoso",
  "nomor_sim": "1234567890",
  "alamat_pengemudi": "Jl. Sudirman No. 123, Jakarta",
  "nama_perusahaan": "PT Angkutan Barang Maju",
  "alamat_perusahaan": "Jl. Gatot Subroto No. 456, Jakarta",
  "nomor_izin": "SIUP-123456789",
  "jenis_izin": "Angkutan Barang",
  "rute": "Jakarta-Bandung",
  "asal": "Jakarta",
  "tujuan": "Bandung",
  "jenis_barang": "Elektronik",
  "berat_kosong": 8.5,
  "berat_muatan": 12.3,
  "berat_total": 20.8,
  "berat_1_axle": 6.2,
  "berat_2_axle": 7.8,
  "berat_3_axle": 6.8,
  "kecepatan": 45.5,
  "jarak_axle": 4.2,
  "status_penimbangan": "berhasil",
  "catatan": "Kendaraan dalam kondisi baik",
  "operator": "Operator 1",
  "shift": "Pagi",
  "kondisi_cuaca": "Cerah",
  "kondisi_jalan": "Kering",
  "is_overload": false,
  "waktu_penimbangan": "2025-01-20T10:30:00Z"
}
```

## Response Handling

Sistem akan menangani response dari Hubnet:

### Success Response (200)
```json
{
  "status": "success",
  "data": {
    "id": "WIM001",
    "processed_at": "2025-01-20T10:30:00Z"
  },
  "message": "Data berhasil diproses"
}
```

### Error Response (400/401/404/500)
```json
{
  "status": "error",
  "data": null,
  "message": "Pesan error dari Hubnet"
}
```

## Monitoring dan Troubleshooting

### 1. Log Monitoring
- Cek log pengiriman di `/api-targets/{id}/logs`
- Monitor response status dan error messages
- Track waktu pengiriman dan response time

### 2. Data Status
- Field `is_sent_to_hubnet` menandakan status pengiriman
- Field `sent_to_hubnet_at` mencatat waktu pengiriman terakhir
- Data yang sudah terkirim tidak akan dikirim ulang

### 3. Common Issues

#### Authentication Error (401)
- Periksa username dan password Basic Auth
- Pastikan kredensial masih valid
- Cek format encoding Base64

#### Connection Timeout
- Periksa koneksi internet
- Cek firewall settings
- Verifikasi URL endpoint Hubnet

#### Data Validation Error (400)
- Periksa format data sesuai skema Hubnet
- Pastikan semua field wajib terisi
- Validasi tipe data (string, integer, decimal)

### 4. Testing

#### Test Connection
1. Klik tombol "Test Connection" pada form API Target
2. Sistem akan test koneksi ke base URL
3. Pastikan endpoint dapat diakses

#### Test Data Send
1. Gunakan tombol "Send Data" untuk test pengiriman
2. Monitor response di logs
3. Verifikasi data diterima di Hubnet

## Security Considerations

1. **Kredensial**: Simpan username/password dengan aman
2. **HTTPS**: Pastikan menggunakan HTTPS untuk komunikasi
3. **Rate Limiting**: Atur rate limit sesuai kebijakan Hubnet
4. **Logging**: Monitor log untuk aktivitas mencurigakan
5. **Backup**: Backup data sebelum pengiriman besar

## Best Practices

1. **Scheduling**: Gunakan jadwal yang tidak membebani sistem
2. **Error Handling**: Tangani error dengan graceful
3. **Monitoring**: Set up alert untuk error berulang
4. **Testing**: Test di environment staging terlebih dahulu
5. **Documentation**: Dokumentasikan perubahan konfigurasi

## Support

Untuk bantuan teknis atau pertanyaan tentang integrasi Hubnet:

1. Cek dokumentasi ini terlebih dahulu
2. Review log error di sistem
3. Hubungi tim support Hubnet untuk masalah API
4. Konsultasi dengan tim development untuk masalah sistem

## Changelog

### Version 1.0.0 (2025-01-20)
- Initial integration with PIA API HUBNET v1.0
- Support for WIM prasarana data
- Support for WIM log data
- Basic authentication support
- Automated data sending
- Comprehensive logging and monitoring 