# API Sources - Sistem Pengirim Data POST Only

## Overview
API Sources telah diubah menjadi sistem **POST-only** yang khusus untuk **mengirim data** dari database lokal ke API endpoint eksternal, bukan untuk mengambil data.

## Perubahan Utama

### 1. **Metode HTTP - POST Only**
- ✅ **Hanya metode POST** yang diizinkan
- ❌ GET, PUT, DELETE sudah dihapus
- 🔄 Semua API Sources existing diupdate ke POST

### 2. **Fungsi Utama - Pengirim Data**
- **Sebelumnya**: Mengambil data dari API eksternal → Simpan ke database lokal
- **Sekarang**: Mengambil data dari database lokal → Kirim ke API eksternal

### 3. **Perubahan Interface**
- Form hanya menampilkan pilihan POST
- Help text diubah ke bahasa Indonesia
- Icon berubah dari database ke paper-plane
- Button "Import Data" → "Kirim Data"

## Cara Kerja Sistem Baru

### 1. **Konfigurasi API Source**
```
Nama: [Nama pengirim data]
URL: [API endpoint tujuan]
Method: POST (otomatis)
Table Name: [Tabel sumber data]
Auth Type: [none/api_key/bearer_token]
```

### 2. **Proses Pengiriman Data**
1. **Ambil data** dari tabel sumber (`table_name`)
2. **Format data** dalam struktur JSON:
   ```json
   {
     "source_table": "nama_tabel",
     "data": [...], // Array data dari tabel
     "timestamp": "2025-07-05T12:06:47.000000Z",
     "source_name": "Nama API Source"
   }
   ```
3. **Kirim POST request** ke URL tujuan
4. **Log hasil** pengiriman

### 3. **Authentication Support**
- **Bearer Token**: `Authorization: Bearer {token}`
- **API Key**: `X-API-Key: {key}`
- **None**: Tanpa authentication

## File yang Diubah

### 1. **Views (Interface)**
- `resources/views/api-sources/create.blade.php`
- `resources/views/api-sources/edit.blade.php`
- `resources/views/api-sources/index.blade.php`
- `resources/views/api-sources/show.blade.php`

### 2. **Controller (Logic)**
- `app/Http/Controllers/ApiSourceController.php`
  - `store()`: Validasi hanya POST
  - `update()`: Validasi hanya POST
  - `import()`: Kirim data via POST
  - `test()`: Test connection via POST

### 3. **Database Migration**
- `database/migrations/2025_07_05_120647_update_api_sources_to_post_only.php`
- Update kolom `method` ke enum('POST')

## Penggunaan

### 1. **Membuat API Source Baru**
1. Buka `/api-sources/create`
2. Isi form:
   - **Nama**: Nama deskriptif
   - **URL**: API endpoint tujuan
   - **Table Name**: Tabel sumber data
   - **Auth Type**: Jenis autentikasi
   - **Token**: Token jika diperlukan
3. Klik "SAVE API SOURCE"

### 2. **Mengirim Data**
1. Buka detail API Source
2. Klik "Kirim Data"
3. Sistem akan:
   - Ambil semua data dari tabel sumber
   - Kirim ke API endpoint
   - Log hasil pengiriman

### 3. **Monitoring**
- Lihat log pengiriman di halaman detail
- Monitor status success/error
- Cek response time dan jumlah records

## API Endpoint Format

### Request yang Dikirim
```http
POST /api/endpoint HTTP/1.1
Content-Type: application/json
Authorization: Bearer {token} // jika ada

{
  "source_table": "users",
  "data": [
    {"id": 1, "name": "John", "email": "john@example.com"},
    {"id": 2, "name": "Jane", "email": "jane@example.com"}
  ],
  "timestamp": "2025-07-05T12:06:47.000000Z",
  "source_name": "User Data Sender"
}
```

### Response yang Diharapkan
```json
{
  "success": true,
  "message": "Data received successfully",
  "records_processed": 2
}
```

## Keamanan

### 1. **Authentication**
- Support Bearer Token dan API Key
- Token disimpan encrypted di database
- Validasi token pada setiap request

### 2. **Rate Limiting**
- Timeout 30 detik untuk pengiriman
- Timeout 10 detik untuk test connection
- Retry mechanism untuk failed requests

### 3. **Data Validation**
- Validasi URL format
- Validasi tabel exists
- Sanitasi data sebelum kirim

## Troubleshooting

### 1. **Connection Error**
- Cek URL endpoint valid
- Pastikan API tujuan online
- Verifikasi authentication token

### 2. **Data Error**
- Pastikan tabel sumber ada data
- Cek format data sesuai ekspektasi API
- Lihat error log untuk detail

### 3. **Authentication Error**
- Verifikasi token masih valid
- Cek format header authentication
- Pastikan API key benar

## Contoh Implementasi

### 1. **Kirim Data User**
```php
// Tabel: users
// URL: https://api.example.com/receive-users
// Method: POST
// Auth: Bearer token123

// Data yang dikirim:
{
  "source_table": "users",
  "data": [
    {"id": 1, "name": "Admin", "email": "admin@example.com"},
    {"id": 2, "name": "User", "email": "user@example.com"}
  ],
  "timestamp": "2025-07-05T12:06:47Z",
  "source_name": "User Data Sync"
}
```

### 2. **Scheduled Sending**
- Manual: Kirim sesuai permintaan
- Hourly: Kirim setiap jam
- Daily: Kirim setiap hari
- Weekly: Kirim setiap minggu

## Status: ✅ IMPLEMENTASI SELESAI

Sistem API Sources sekarang berfungsi sebagai **POST-only data sender** yang mengirim data dari database lokal ke API eksternal dengan fitur authentication, logging, dan monitoring yang lengkap. 