<?php

echo "Fetching gold price data from Logam Mulia API\n";

// Try different endpoints
$endpoints = [
    'https://logam-mulia-api.vercel.app/prices/logammulia',
    'https://logam-mulia-api.vercel.app/prices/anekalogam',
    'https://logam-mulia-api.vercel.app/prices/hargaemas',
    'https://logam-mulia-api.vercel.app/prices/pegadaian',
    'https://logam-mulia-api.vercel.app/sites'
];

foreach ($endpoints as $endpoint) {
    echo "\nTrying endpoint: $endpoint\n";
    
    $context = stream_context_create([
        'http' => [
            'timeout' => 30,
            'user_agent' => 'API8-Import-Script/1.0'
        ]
    ]);

    $response = file_get_contents($endpoint, false, $context);
    
    if ($response !== false) {
        $data = json_decode($response, true);
        
        if ($data) {
            echo "Success! Got data from: $endpoint\n";
            echo "Response structure: " . json_encode(array_keys($data)) . "\n";
            
            // Save to file
            $filename = 'gold_data_' . date('Y-m-d_H-i-s') . '.json';
            file_put_contents($filename, json_encode($data, JSON_PRETTY_PRINT));
            echo "Data saved to: $filename\n";
            
            // Show sample data
            if (isset($data['data']) && is_array($data['data'])) {
                echo "Sample data:\n";
                $sample = array_slice($data['data'], 0, 3);
                foreach ($sample as $item) {
                    if (is_array($item)) {
                        echo "  " . json_encode($item) . "\n";
                    }
                }
            }
            
            break; // Stop after first successful endpoint
        } else {
            echo "Failed to decode JSON from: $endpoint\n";
        }
    } else {
        echo "Failed to fetch from: $endpoint\n";
    }
}

echo "\nFetch process completed.\n"; 