<?php

// Script to fix API routes on production server
echo "=== Fixing API Routes ===\n";

// Clear all Laravel caches
$commands = [
    'php artisan route:clear',
    'php artisan cache:clear',
    'php artisan config:clear',
    'php artisan view:clear',
    'php artisan optimize:clear',
    'php artisan route:cache',
    'php artisan config:cache'
];

foreach ($commands as $command) {
    echo "Running: {$command}\n";
    $output = shell_exec($command . ' 2>&1');
    echo $output . "\n";
}

// Check if routes are now registered
echo "\n=== Checking Routes ===\n";
$routeOutput = shell_exec('php artisan route:list --path=api/post 2>&1');
echo $routeOutput . "\n";

// Test the API endpoint again
echo "\n=== Testing API Endpoint ===\n";

$endpoint = 'sample-webhook';
$url = "https://copilotproduction.site/api/post/{$endpoint}";

$data = [
    'test_field' => 'test_value',
    'timestamp' => date('Y-m-d H:i:s'),
    'source' => 'fix_script'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Accept: application/json'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "URL: {$url}\n";
echo "HTTP Code: {$httpCode}\n";

if ($error) {
    echo "cURL Error: {$error}\n";
}

echo "Response:\n";
echo $response . "\n";

// Check if it's JSON now
$jsonData = json_decode($response, true);
if (json_last_error() === JSON_ERROR_NONE) {
    echo "✅ Response is now valid JSON\n";
    print_r($jsonData);
} else {
    echo "❌ Response is still not valid JSON\n";
    echo "JSON Error: " . json_last_error_msg() . "\n";
}

echo "\n=== Fix Complete ===\n"; 