<?php
/**
 * Database Configuration Fix Script
 * Use this to diagnose and fix database connection issues
 */

// Set time limit
set_time_limit(300);

echo "<h1>🔧 Database Configuration Fix</h1>";
echo "<p><strong>Time:</strong> " . date('Y-m-d H:i:s') . "</p>";
echo "<hr>";

// Check if .env file exists
$envFile = __DIR__ . '/.env';
$envExists = file_exists($envFile);

echo "<h2>📋 Environment Check</h2>";
echo "<p><strong>.env file exists:</strong> " . ($envExists ? '✅ Yes' : '❌ No') . "</p>";

if (!$envExists) {
    echo "<div style='background: #fff3cd; color: #856404; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
    echo "<h3>⚠️ .env File Missing</h3>";
    echo "<p>The .env file is missing. This is the most likely cause of your database connection issues.</p>";
    echo "<p><strong>Solution:</strong> Create a .env file with the following content:</p>";
    echo "<pre style='background: #f8f9fa; padding: 15px; border-radius: 5px; overflow-x: auto;'>";
    echo "APP_NAME=\"API Management System\"\n";
    echo "APP_ENV=production\n";
    echo "APP_KEY=base64:YourAppKeyHere\n";
    echo "APP_DEBUG=false\n";
    echo "APP_URL=https://copilotproduction.site\n\n";
    echo "LOG_CHANNEL=stack\n";
    echo "LOG_LEVEL=debug\n\n";
    echo "DB_CONNECTION=mysql\n";
    echo "DB_HOST=127.0.0.1\n";
    echo "DB_PORT=3306\n";
    echo "DB_DATABASE=copg1493_api\n";
    echo "DB_USERNAME=copg1493_api\n";
    echo "DB_PASSWORD=P7H_s;Aco25Vv??J\n\n";
    echo "BROADCAST_DRIVER=log\n";
    echo "CACHE_DRIVER=file\n";
    echo "FILESYSTEM_DISK=local\n";
    echo "QUEUE_CONNECTION=sync\n";
    echo "SESSION_DRIVER=file\n";
    echo "SESSION_LIFETIME=120\n";
    echo "</pre>";
    echo "</div>";
} else {
    echo "<p>✅ .env file exists. Checking configuration...</p>";
    
    // Read .env file
    $envContent = file_get_contents($envFile);
    
    // Check for database configuration
    $dbConfigs = [
        'DB_CONNECTION' => 'mysql',
        'DB_HOST' => '127.0.0.1',
        'DB_PORT' => '3306',
        'DB_DATABASE' => 'copg1493_api',
        'DB_USERNAME' => 'copg1493_api',
        'DB_PASSWORD' => 'P7H_s;Aco25Vv??J'
    ];
    
    echo "<h3>📊 Database Configuration Check</h3>";
    echo "<table style='border-collapse: collapse; width: 100%;'>";
    echo "<tr style='background: #f8f9fa;'><th style='padding: 10px; border: 1px solid #ddd;'>Setting</th><th style='padding: 10px; border: 1px solid #ddd;'>Expected</th><th style='padding: 10px; border: 1px solid #ddd;'>Current</th><th style='padding: 10px; border: 1px solid #ddd;'>Status</th></tr>";
    
    foreach ($dbConfigs as $key => $expected) {
        $current = env($key, 'NOT SET');
        $status = ($current === $expected) ? '✅ OK' : '❌ WRONG';
        
        echo "<tr>";
        echo "<td style='padding: 10px; border: 1px solid #ddd;'>{$key}</td>";
        echo "<td style='padding: 10px; border: 1px solid #ddd;'>{$expected}</td>";
        echo "<td style='padding: 10px; border: 1px solid #ddd;'>{$current}</td>";
        echo "<td style='padding: 10px; border: 1px solid #ddd;'>{$status}</td>";
        echo "</tr>";
    }
    echo "</table>";
}

// Test database connection
echo "<h2>🔌 Database Connection Test</h2>";

try {
    // Try to connect to database
    $pdo = new PDO(
        'mysql:host=127.0.0.1;dbname=copg1493_api',
        'copg1493_api',
        'P7H_s;Aco25Vv??J'
    );
    
    echo "<p style='color: green;'>✅ Database connection successful!</p>";
    
    // Test query
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM information_schema.tables WHERE table_schema = 'copg1493_api'");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "<p>📊 Database has {$result['count']} tables</p>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Database connection failed: " . $e->getMessage() . "</p>";
    
    // Provide troubleshooting steps
    echo "<div style='background: #ffe6e6; color: #721c24; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
    echo "<h3>🛠️ Troubleshooting Steps</h3>";
    echo "<ol>";
    echo "<li>Verify database credentials with your hosting provider</li>";
    echo "<li>Check if the database 'copg1493_api' exists</li>";
    echo "<li>Ensure the user 'copg1493_api' has proper permissions</li>";
    echo "<li>Test connection from MySQL client or phpMyAdmin</li>";
    echo "<li>Check if MySQL service is running</li>";
    echo "</ol>";
    echo "</div>";
}

// Check Laravel configuration
echo "<h2>⚙️ Laravel Configuration Check</h2>";

try {
    // Check if Laravel can load configuration
    $output = [];
    exec("php artisan config:show database.connections.mysql 2>&1", $output, $returnCode);
    
    if ($returnCode === 0) {
        echo "<p style='color: green;'>✅ Laravel configuration loaded successfully</p>";
        echo "<details><summary>Show database config</summary>";
        echo "<pre style='background: #f8f9fa; padding: 10px; border-radius: 5px;'>";
        echo htmlspecialchars(implode("\n", $output));
        echo "</pre></details>";
    } else {
        echo "<p style='color: red;'>❌ Laravel configuration failed to load</p>";
        echo "<pre style='background: #ffe6e6; padding: 10px; border-radius: 5px;'>";
        echo htmlspecialchars(implode("\n", $output));
        echo "</pre>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error checking Laravel config: " . $e->getMessage() . "</p>";
}

// Check if migrations table exists
echo "<h2>📋 Migration Status Check</h2>";

try {
    $pdo = new PDO(
        'mysql:host=127.0.0.1;dbname=copg1493_api',
        'copg1493_api',
        'P7H_s;Aco25Vv??J'
    );
    
    $stmt = $pdo->query("SHOW TABLES LIKE 'migrations'");
    $migrationTableExists = $stmt->rowCount() > 0;
    
    if ($migrationTableExists) {
        echo "<p style='color: green;'>✅ Migrations table exists</p>";
        
        // Check if post_only_receivers table exists
        $stmt = $pdo->query("SHOW TABLES LIKE 'post_only_receivers'");
        $postOnlyTableExists = $stmt->rowCount() > 0;
        
        if ($postOnlyTableExists) {
            echo "<p style='color: green;'>✅ post_only_receivers table exists</p>";
        } else {
            echo "<p style='color: orange;'>⚠️ post_only_receivers table does not exist - migrations need to be run</p>";
        }
        
    } else {
        echo "<p style='color: red;'>❌ Migrations table does not exist - database needs to be initialized</p>";
    }
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Cannot check migration status: " . $e->getMessage() . "</p>";
}

// Generate App Key
echo "<h2>🔑 Application Key Check</h2>";

try {
    $output = [];
    exec("php artisan key:generate --show 2>&1", $output, $returnCode);
    
    if ($returnCode === 0) {
        $appKey = trim(implode("\n", $output));
        echo "<p style='color: green;'>✅ Application key generated: <code>{$appKey}</code></p>";
        echo "<p><strong>Add this to your .env file:</strong> <code>APP_KEY={$appKey}</code></p>";
    } else {
        echo "<p style='color: red;'>❌ Failed to generate app key</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error generating app key: " . $e->getMessage() . "</p>";
}

// Action buttons
echo "<hr>";
echo "<h2>🚀 Quick Actions</h2>";
echo "<div style='margin: 20px 0;'>";
echo "<a href='/deploy-post-receivers.php' style='background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-right: 10px;'>🚀 Run Full Deployment</a>";
echo "<a href='/clear-cache-post-receivers.php' style='background: #28a745; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px; margin-right: 10px;'>🧹 Clear Cache</a>";
echo "</div>";

echo "<h3>📝 Manual Steps</h3>";
echo "<div style='background: #f8f9fa; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
echo "<p><strong>If database connection is working, run these commands:</strong></p>";
echo "<code>php artisan key:generate</code><br>";
echo "<code>php artisan migrate --force</code><br>";
echo "<code>php artisan config:clear</code><br>";
echo "<code>php artisan route:clear</code><br>";
echo "<code>php artisan view:clear</code><br>";
echo "<code>php artisan cache:clear</code><br>";
echo "</div>";

echo "<hr>";
echo "<p><small>Fix completed at: " . date('Y-m-d H:i:s') . "</small></p>";
echo "<p><small>Script: fix-database-config.php</small></p>";
?> 