<?php
// Comprehensive fix for post-only-receivers routes
echo "<h2>🔧 Fixing POST-Only Receivers Routes</h2>";

try {
    // Step 1: Clear all cache
    echo "<h3>Step 1: Clearing All Cache</h3>";
    
    $commands = [
        'route:clear' => 'Route Cache',
        'config:clear' => 'Config Cache',
        'cache:clear' => 'Application Cache',
        'view:clear' => 'View Cache',
        'optimize:clear' => 'Optimized Files'
    ];
    
    foreach ($commands as $command => $name) {
        $result = shell_exec("php artisan $command 2>&1");
        $status = $result ? (strpos($result, 'cleared') !== false ? '✅' : '⚠️') : '✅';
        echo "<p>$status <strong>$name:</strong> " . ($result ?: 'Success') . "</p>";
    }
    
    // Step 2: Test route registration
    echo "<h3>Step 2: Testing Route Registration</h3>";
    
    // Check if routes are registered
    $routeList = shell_exec('php artisan route:list --name=post-only-receivers 2>&1');
    if ($routeList && strpos($routeList, 'post-only-receivers.index') !== false) {
        echo "<p style='color: green;'>✅ POST-Only Receivers routes are registered</p>";
        echo "<pre style='background: #f8f9fa; padding: 10px; border-radius: 4px;'>$routeList</pre>";
    } else {
        echo "<p style='color: red;'>❌ POST-Only Receivers routes not found</p>";
        echo "<p>Route list output: $routeList</p>";
    }
    
    // Step 3: Test route access
    echo "<h3>Step 3: Testing Route Access</h3>";
    
    $testUrl = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . '/post-only-receivers';
    
    $context = stream_context_create([
        'http' => [
            'method' => 'GET',
            'header' => 'User-Agent: Route Test',
            'timeout' => 10,
            'ignore_errors' => true
        ]
    ]);
    
    $response = @file_get_contents($testUrl, false, $context);
    $httpCode = isset($http_response_header[0]) ? $http_response_header[0] : 'No response';
    
    echo "<p><strong>Route Test URL:</strong> $testUrl</p>";
    echo "<p><strong>Response:</strong> $httpCode</p>";
    
    if (strpos($httpCode, '200') !== false) {
        echo "<p style='color: green;'>✅ Route is accessible and working!</p>";
    } else if (strpos($httpCode, '302') !== false) {
        echo "<p style='color: orange;'>⚠️ Route redirecting (authentication required)</p>";
    } else if (strpos($httpCode, '404') !== false) {
        echo "<p style='color: red;'>❌ Route still returns 404</p>";
    } else if (strpos($httpCode, '500') !== false) {
        echo "<p style='color: red;'>❌ Server error (500) - Check Laravel logs</p>";
    } else {
        echo "<p style='color: orange;'>⚠️ Unexpected response: $httpCode</p>";
    }
    
    // Step 4: Check controller and model
    echo "<h3>Step 4: Checking Controller and Model</h3>";
    
    $controllerPath = __DIR__ . '/app/Http/Controllers/PostOnlyReceiverController.php';
    $modelPath = __DIR__ . '/app/Models/PostOnlyReceiver.php';
    
    if (file_exists($controllerPath)) {
        echo "<p style='color: green;'>✅ PostOnlyReceiverController exists</p>";
    } else {
        echo "<p style='color: red;'>❌ PostOnlyReceiverController not found</p>";
    }
    
    if (file_exists($modelPath)) {
        echo "<p style='color: green;'>✅ PostOnlyReceiver model exists</p>";
    } else {
        echo "<p style='color: red;'>❌ PostOnlyReceiver model not found</p>";
    }
    
    // Step 5: Database check
    echo "<h3>Step 5: Database Check</h3>";
    
    try {
        // Try to connect to database and check table
        $dbCheck = shell_exec('php artisan tinker --execute="echo \\App\\Models\\PostOnlyReceiver::count();" 2>&1');
        if (is_numeric(trim($dbCheck))) {
            echo "<p style='color: green;'>✅ Database connection and table OK (Records: " . trim($dbCheck) . ")</p>";
        } else {
            echo "<p style='color: orange;'>⚠️ Database check result: $dbCheck</p>";
        }
    } catch (Exception $e) {
        echo "<p style='color: red;'>❌ Database check failed: " . $e->getMessage() . "</p>";
    }
    
    echo "<hr>";
    echo "<h3 style='color: blue;'>🎯 Summary</h3>";
    echo "<p>All cache has been cleared and routes have been tested.</p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h3>📋 Next Steps:</h3>";
echo "<ol>";
echo "<li>Try accessing the application again</li>";
echo "<li>If still getting route errors, try restarting the web server</li>";
echo "<li>Check Laravel logs at storage/logs/laravel.log</li>";
echo "<li>Contact hosting provider if issues persist</li>";
echo "</ol>";

echo "<p><strong>Fix completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?> 