<?php
// Fix route cache issue for post-only-receivers
echo "<h2>🔧 Fixing Route Cache Issue</h2>";

try {
    // Clear route cache
    $routeClearResult = shell_exec('php artisan route:clear 2>&1');
    echo "<p><strong>Route Cache Clear:</strong> " . ($routeClearResult ? $routeClearResult : 'Success') . "</p>";
    
    // Clear config cache
    $configClearResult = shell_exec('php artisan config:clear 2>&1');
    echo "<p><strong>Config Cache Clear:</strong> " . ($configClearResult ? $configClearResult : 'Success') . "</p>";
    
    // Clear application cache
    $cacheClearResult = shell_exec('php artisan cache:clear 2>&1');
    echo "<p><strong>Application Cache Clear:</strong> " . ($cacheClearResult ? $cacheClearResult : 'Success') . "</p>";
    
    // Clear view cache
    $viewClearResult = shell_exec('php artisan view:clear 2>&1');
    echo "<p><strong>View Cache Clear:</strong> " . ($viewClearResult ? $viewClearResult : 'Success') . "</p>";
    
    // Clear optimized files
    $optimizeClearResult = shell_exec('php artisan optimize:clear 2>&1');
    echo "<p><strong>Optimize Clear:</strong> " . ($optimizeClearResult ? $optimizeClearResult : 'Success') . "</p>";
    
    echo "<hr>";
    echo "<h3 style='color: green;'>✅ All Cache Cleared Successfully!</h3>";
    
    // Test if post-only-receivers route is now available
    echo "<h3>🧪 Testing Routes:</h3>";
    
    // Check if we can access the route
    $testUrl = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . '/post-only-receivers';
    
    $context = stream_context_create([
        'http' => [
            'method' => 'GET',
            'header' => 'User-Agent: Route Test',
            'timeout' => 5,
            'ignore_errors' => true
        ]
    ]);
    
    $response = @file_get_contents($testUrl, false, $context);
    $httpCode = isset($http_response_header[0]) ? $http_response_header[0] : 'No response';
    
    echo "<p><strong>POST-Only Receivers Route Test:</strong> $httpCode</p>";
    
    if (strpos($httpCode, '200') !== false) {
        echo "<p style='color: green;'>✅ Route is working correctly!</p>";
    } else if (strpos($httpCode, '302') !== false) {
        echo "<p style='color: orange;'>⚠️ Route redirecting (probably authentication required)</p>";
    } else if (strpos($httpCode, '404') !== false) {
        echo "<p style='color: red;'>❌ Route still not found</p>";
    } else {
        echo "<p style='color: orange;'>⚠️ Route responding with: $httpCode</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h3>📋 Next Steps:</h3>";
echo "<ol>";
echo "<li>Try accessing the application again</li>";
echo "<li>If still getting route errors, check Laravel logs</li>";
echo "<li>Consider restarting web server if on shared hosting</li>";
echo "</ol>";

echo "<p><strong>Script completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?> 