-- Manual SQL untuk memperbaiki auth_type ENUM
-- Jalankan ini di phpMyAdmin atau MySQL client

-- 1. Cek definisi kolom saat ini
SHOW COLUMNS FROM api_receivers WHERE Field = 'auth_type';

-- 2. Modifikasi ENUM untuk menambahkan 'basic_auth' dan 'bearer_token'
ALTER TABLE api_receivers 
MODIFY COLUMN auth_type ENUM(
    'none', 
    'api_key', 
    'bearer_token', 
    'basic_auth', 
    'hmac_signature'
) DEFAULT 'none';

-- 3. Verifikasi perubahan
SHOW COLUMNS FROM api_receivers WHERE Field = 'auth_type';

-- Hasil yang diharapkan:
-- Field: auth_type
-- Type: enum('none','api_key','bearer_token','basic_auth','hmac_signature')
-- Default: none
