<?php

// File untuk memperbaiki receiver Baden langsung di database
// Jalankan file ini di hosting untuk memperbaiki konfigurasi

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;

try {
    echo "=== Memperbaiki Receiver Baden ===\n";
    
    // 1. Cek apakah receiver ada
    $receiver = DB::table('api_receivers')->where('endpoint', 'baden')->first();
    
    if ($receiver) {
        echo "✅ Receiver 'baden' ditemukan di database\n";
        echo "ID: {$receiver->id}\n";
        echo "Name: {$receiver->name}\n";
        echo "Current Auth Type: {$receiver->auth_type}\n";
        echo "Current Username: " . ($receiver->auth_username ?? 'NULL') . "\n";
        echo "Current Password: " . ($receiver->auth_password ?? 'NULL') . "\n";
        echo "Is Active: " . ($receiver->is_active ? 'Yes' : 'No') . "\n\n";
        
        // 2. Update receiver dengan Basic Auth
        $updated = DB::table('api_receivers')
            ->where('endpoint', 'baden')
            ->update([
                'auth_type' => 'basic_auth',
                'auth_username' => 'baden',
                'auth_password' => 'baden',
                'is_active' => 1,
                'allowed_methods' => 'GET,POST,PUT,DELETE',
                'updated_at' => now()
            ]);
        
        if ($updated) {
            echo "✅ Receiver berhasil diupdate!\n";
        } else {
            echo "❌ Gagal mengupdate receiver\n";
        }
        
    } else {
        echo "❌ Receiver 'baden' tidak ditemukan\n";
        echo "Membuat receiver baru...\n";
        
        // 3. Buat receiver baru jika tidak ada
        $newId = DB::table('api_receivers')->insertGetId([
            'name' => 'Baden Basic Auth Receiver',
            'description' => 'Receiver for Baden System with Basic Authentication',
            'endpoint' => 'baden',
            'target_table' => 'orders',
            'auth_type' => 'basic_auth',
            'auth_username' => 'baden',
            'auth_password' => 'baden',
            'allowed_methods' => 'GET,POST,PUT,DELETE',
            'rate_limit' => 100,
            'auto_create_table' => 1,
            'is_active' => 1,
            'is_bidirectional' => 1,
            'duplicate_handling' => 'update',
            'unique_fields' => 'order_id',
            'data_filter' => 'all',
            'max_records_per_request' => 100,
            'enable_scheduling' => 1,
            'schedule_type' => 'interval',
            'schedule_interval' => 5,
            'timezone' => 'Asia/Jakarta',
            'response_format' => 'json',
            'auto_acknowledge' => 1,
            'retry_attempts' => 3,
            'retry_delay' => 60,
            'validation_rules' => json_encode([
                'order_id' => ['required' => true, 'type' => 'string'],
                'customer_name' => ['required' => true, 'type' => 'string'],
                'total_amount' => ['required' => true, 'type' => 'numeric']
            ]),
            'created_at' => now(),
            'updated_at' => now()
        ]);
        
        echo "✅ Receiver baru berhasil dibuat dengan ID: $newId\n";
    }
    
    // 4. Verifikasi update
    $updatedReceiver = DB::table('api_receivers')->where('endpoint', 'baden')->first();
    
    if ($updatedReceiver) {
        echo "\n=== Verifikasi Konfigurasi ===\n";
        echo "ID: {$updatedReceiver->id}\n";
        echo "Name: {$updatedReceiver->name}\n";
        echo "Auth Type: {$updatedReceiver->auth_type}\n";
        echo "Username: {$updatedReceiver->auth_username}\n";
        echo "Password: {$updatedReceiver->auth_password}\n";
        echo "Is Active: " . ($updatedReceiver->is_active ? 'Yes' : 'No') . "\n";
        echo "Allowed Methods: {$updatedReceiver->allowed_methods}\n";
        
        // 5. Test credentials
        $testCredentials = base64_encode('baden:baden');
        echo "\n=== Test Credentials ===\n";
        echo "Username: baden\n";
        echo "Password: baden\n";
        echo "Encoded: $testCredentials\n";
        echo "Authorization Header: Basic $testCredentials\n";
        
        echo "\n🎉 Konfigurasi selesai! Sekarang coba test dengan:\n";
        echo "URL: https://copilotproduction.site/api/in/baden\n";
        echo "Method: POST\n";
        echo "Headers:\n";
        echo "  Authorization: Basic $testCredentials\n";
        echo "  Content-Type: application/json\n";
        echo "Body: {\"test\": \"data\"}\n";
        
    } else {
        echo "❌ Gagal memverifikasi receiver\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}
