<?php
require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\\Contracts\\Console\\Kernel')->bootstrap();

use App\Models\ApiReceiver;

echo "=== FIXING RECEIVERS TO ALLOW POST ===\n\n";

$receivers = ApiReceiver::where('is_active', true)->get();
if ($receivers->isEmpty()) {
    echo "No active receivers found.\n";
    exit(0);
}
foreach ($receivers as $r) {
    $methods = array_map('trim', explode(',', $r->allowed_methods));
    if (!in_array('POST', $methods)) {
        $methods[] = 'POST';
        $r->allowed_methods = implode(',', array_unique($methods));
        $r->save();
        echo "[UPDATED] endpoint: {$r->endpoint} | allowed_methods: {$r->allowed_methods}\n";
    } else {
        echo "[OK] endpoint: {$r->endpoint} | allowed_methods: {$r->allowed_methods}\n";
    }
}

// Perbaiki allowed_methods untuk endpoint efficient-endpoint-580
echo "Memperbaiki allowed_methods untuk endpoint efficient-endpoint-580...\n";

$receiver = ApiReceiver::where('endpoint', 'efficient-endpoint-580')->first();
if ($receiver) {
    $receiver->allowed_methods = 'GET,POST';
    $receiver->save();
    echo "[UPDATED] endpoint: {$receiver->endpoint} | allowed_methods: {$receiver->allowed_methods}\n";
} else {
    echo "[NOT FOUND] endpoint: efficient-endpoint-580\n";
}

echo "\n=== DONE ===\n"; 