<?php

require_once 'vendor/autoload.php';

use Illuminate\Database\Capsule\Manager as DB;

// Bootstrap Laravel
$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\ApiTarget;

echo "=== FIX API TARGETS METHOD TO POST ===\n\n";

// Ambil semua target aktif yang method-nya bukan POST
$targets = ApiTarget::where('is_active', 1)
    ->where('method', '!=', 'POST')
    ->get();

if ($targets->isEmpty()) {
    echo "✓ Semua API Target aktif sudah menggunakan metode POST\n";
    exit(0);
}

foreach ($targets as $target) {
    $oldMethod = $target->method;
    $target->method = 'POST';
    $target->save();
    echo "- [ID: {$target->id}] {$target->name}: {$oldMethod} => POST\n";
}

echo "\n✓ Selesai. Semua API Target aktif sekarang menggunakan metode POST.\n"; 