<?php
// Script untuk menjalankan migration di server
// File: migrate-on-server.php

echo "<h1>🔧 Running Laravel Migrations on Server</h1>";

// Change to Laravel directory
$laravelPath = __DIR__;
chdir($laravelPath);

echo "<p><strong>Current Directory:</strong> " . getcwd() . "</p>";
echo "<p><strong>PHP Version:</strong> " . phpversion() . "</p>";
echo "<p><strong>Timestamp:</strong> " . date('Y-m-d H:i:s T') . "</p>";

echo "<hr>";

// Check if artisan exists
if (file_exists('artisan')) {
    echo "<p>✅ Artisan file found</p>";
    
    // Run migration
    echo "<h2>Running Migration...</h2>";
    echo "<pre>";
    
    // Capture output
    $output = [];
    $returnCode = 0;
    
    exec('php artisan migrate --force 2>&1', $output, $returnCode);
    
    foreach ($output as $line) {
        echo htmlspecialchars($line) . "\n";
    }
    
    echo "</pre>";
    
    if ($returnCode === 0) {
        echo "<p style='color: green; font-weight: bold;'>✅ Migration completed successfully!</p>";
    } else {
        echo "<p style='color: red; font-weight: bold;'>❌ Migration failed with return code: $returnCode</p>";
    }
    
} else {
    echo "<p style='color: red;'>❌ Artisan file not found. Make sure this script is in Laravel root directory.</p>";
}

echo "<hr>";
echo "<p><em>Migration completed at: " . date('Y-m-d H:i:s T') . "</em></p>";
echo "<p><em>Delete this file after migration is complete</em></p>";
?> 