<?php

// Script untuk mengecek log Laravel di hosting
echo "=== LARAVEL LOG CHECK ===\n";

$logFile = '../storage/logs/laravel.log';

echo "1. Checking Laravel log file...\n";
if (file_exists($logFile)) {
    echo "   ✅ Log file exists\n";
    
    // Get file size
    $size = filesize($logFile);
    echo "   📏 File size: " . number_format($size) . " bytes\n";
    
    // Read last 20 lines
    echo "\n2. Last 20 log entries:\n";
    $lines = file($logFile);
    $lastLines = array_slice($lines, -20);
    
    foreach ($lastLines as $line) {
        // Highlight important keywords
        $line = str_replace('ERROR', "\033[31mERROR\033[0m", $line);
        $line = str_replace('WARNING', "\033[33mWARNING\033[0m", $line);
        $line = str_replace('INFO', "\033[32mINFO\033[0m", $line);
        $line = str_replace('ujicoba', "\033[36mujicoba\033[0m", $line);
        $line = str_replace('database', "\033[35mdatabase\033[0m", $line);
        
        echo "   " . trim($line) . "\n";
    }
    
} else {
    echo "   ❌ Log file not found\n";
    echo "   💡 Check if storage/logs directory exists and is writable\n";
}

// Check for error log
echo "\n3. Checking PHP error log...\n";
$errorLog = ini_get('error_log');
if ($errorLog && file_exists($errorLog)) {
    echo "   📝 PHP Error log: $errorLog\n";
    $size = filesize($errorLog);
    echo "   📏 Size: " . number_format($size) . " bytes\n";
} else {
    echo "   📝 PHP Error log: Not configured or not found\n";
}

// Check storage permissions
echo "\n4. Storage directory permissions:\n";
$storageDir = '../storage';
$logsDir = '../storage/logs';

if (is_dir($storageDir)) {
    echo "   ✅ Storage directory exists\n";
    echo "   📂 Permissions: " . substr(sprintf('%o', fileperms($storageDir)), -4) . "\n";
} else {
    echo "   ❌ Storage directory not found\n";
}

if (is_dir($logsDir)) {
    echo "   ✅ Logs directory exists\n";
    echo "   📂 Permissions: " . substr(sprintf('%o', fileperms($logsDir)), -4) . "\n";
} else {
    echo "   ❌ Logs directory not found\n";
}

echo "\n=== END LOG CHECK ===\n"; 