<?php

// One-time script to create an admin user.
// Usage (GET params optional):
//   /create-admin.php?email=admin@copilotproduction.site&password=StrongPass123!&name=Administrator
// IMPORTANT: Delete this file after use.

require_once __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

header('Content-Type: text/plain');

try {
    $flagPath = storage_path('app/admin_created.flag');

    if (file_exists($flagPath)) {
        echo "Admin creation has already been executed.\n";
        echo "If you need to reset password, pass ?reset=1&email=...&password=...\n";
        echo "Flag file: {$flagPath}\n";
        exit;
    }

    $email = isset($_GET['email']) && filter_var($_GET['email'], FILTER_VALIDATE_EMAIL)
        ? trim($_GET['email'])
        : 'admin@copilotproduction.site';

    $name = isset($_GET['name']) && $_GET['name'] !== ''
        ? trim($_GET['name'])
        : 'Administrator';

    $plainPassword = isset($_GET['password']) && $_GET['password'] !== ''
        ? (string) $_GET['password']
        : Str::random(16);

    $user = User::where('email', $email)->first();

    if (!$user) {
        $user = new User();
        $user->name = $name;
        $user->email = $email;
        $user->password = Hash::make($plainPassword);
        $user->save();

        @file_put_contents($flagPath, json_encode([
            'created_at' => now()->toIso8601String(),
            'email' => $email,
        ], JSON_PRETTY_PRINT));

        echo "✅ Admin user created successfully.\n\n";
        echo "Login URL : https://copilotproduction.site/login\n";
        echo "Email     : {$email}\n";
        echo "Password  : {$plainPassword}\n";
        echo "\nPlease delete this file: public/create-admin.php\n";
        exit;
    }

    // If user exists, optionally reset password when reset=1
    $shouldReset = isset($_GET['reset']) && (string) $_GET['reset'] === '1';
    if ($shouldReset) {
        $user->password = Hash::make($plainPassword);
        if (isset($_GET['name']) && $_GET['name'] !== '') {
            $user->name = $name;
        }
        $user->save();

        @file_put_contents($flagPath, json_encode([
            'reset_at' => now()->toIso8601String(),
            'email' => $email,
        ], JSON_PRETTY_PRINT));

        echo "✅ Existing admin password has been reset.\n\n";
        echo "Login URL : https://copilotproduction.site/login\n";
        echo "Email     : {$email}\n";
        echo "Password  : {$plainPassword}\n";
        echo "\nPlease delete this file: public/create-admin.php\n";
        exit;
    }

    echo "ℹ️  User with email '{$email}' already exists. No changes were made.\n";
    echo "To reset password, call: /create-admin.php?reset=1&email=" . urlencode($email) . "&password=NewStrongPass\n";
    echo "\nPlease delete this file if not needed: public/create-admin.php\n";
} catch (Throwable $e) {
    http_response_code(500);
    echo "❌ Failed to create admin: " . $e->getMessage() . "\n";
}


