<?php

require_once '../vendor/autoload.php';

$app = require_once '../bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

try {
    echo "<h2>📊 Creating Sample Data for Baden Endpoint</h2>";
    
    // Check if orders table exists
    if (!Schema::hasTable('orders')) {
        echo "<p style='color: red;'>❌ Table 'orders' tidak ditemukan!</p>";
        echo "<p>Membuat tabel orders...</p>";
        
        Schema::create('orders', function ($table) {
            $table->id();
            $table->string('order_id')->unique();
            $table->string('customer_name');
            $table->decimal('total_amount', 10, 2);
            $table->json('items')->nullable();
            $table->string('status')->default('pending');
            $table->boolean('processed')->default(false);
            $table->timestamp('processed_at')->nullable();
            $table->timestamps();
            
            $table->index('order_id');
            $table->index('processed');
            $table->index('status');
        });
        
        echo "<p style='color: green;'>✅ Tabel 'orders' berhasil dibuat!</p>";
    } else {
        echo "<p style='color: green;'>✅ Tabel 'orders' sudah ada</p>";
    }
    
    // Check if there's already data
    $existingCount = DB::table('orders')->count();
    echo "<p>📈 Jumlah data existing: {$existingCount}</p>";
    
    if ($existingCount > 0) {
        echo "<p style='color: orange;'>⚠️ Data sudah ada di tabel orders</p>";
        echo "<p>Menampilkan data existing:</p>";
        
        $existingData = DB::table('orders')->orderBy('created_at', 'desc')->limit(5)->get();
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr style='background-color: #f0f0f0;'>";
        echo "<th>ID</th><th>Order ID</th><th>Customer</th><th>Amount</th><th>Status</th><th>Created</th>";
        echo "</tr>";
        
        foreach ($existingData as $order) {
            echo "<tr>";
            echo "<td>{$order->id}</td>";
            echo "<td>{$order->order_id}</td>";
            echo "<td>{$order->customer_name}</td>";
            echo "<td>Rp " . number_format($order->total_amount, 0, ',', '.') . "</td>";
            echo "<td>{$order->status}</td>";
            echo "<td>{$order->created_at}</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p>📝 Membuat sample data...</p>";
        
        // Sample data for orders table
        $sampleOrders = [
            [
                'order_id' => 'ORD-001',
                'customer_name' => 'Ahmad Dhani',
                'total_amount' => 150000.00,
                'items' => json_encode([
                    ['name' => 'Laptop Asus', 'qty' => 1, 'price' => 150000.00]
                ]),
                'status' => 'completed',
                'processed' => true,
                'processed_at' => now()->subDays(2),
                'created_at' => now()->subDays(3),
                'updated_at' => now()->subDays(2)
            ],
            [
                'order_id' => 'ORD-002',
                'customer_name' => 'Siti Nurhaliza',
                'total_amount' => 250000.00,
                'items' => json_encode([
                    ['name' => 'Smartphone Samsung', 'qty' => 1, 'price' => 250000.00]
                ]),
                'status' => 'pending',
                'processed' => false,
                'created_at' => now()->subDays(1),
                'updated_at' => now()->subDays(1)
            ],
            [
                'order_id' => 'ORD-003',
                'customer_name' => 'Budi Santoso',
                'total_amount' => 75000.00,
                'items' => json_encode([
                    ['name' => 'Headphone Sony', 'qty' => 1, 'price' => 75000.00]
                ]),
                'status' => 'processing',
                'processed' => false,
                'created_at' => now()->subHours(6),
                'updated_at' => now()->subHours(6)
            ],
            [
                'order_id' => 'ORD-004',
                'customer_name' => 'Dewi Sartika',
                'total_amount' => 320000.00,
                'items' => json_encode([
                    ['name' => 'Tablet iPad', 'qty' => 1, 'price' => 320000.00]
                ]),
                'status' => 'completed',
                'processed' => true,
                'processed_at' => now()->subHours(2),
                'created_at' => now()->subHours(4),
                'updated_at' => now()->subHours(2)
            ],
            [
                'order_id' => 'ORD-005',
                'customer_name' => 'Rudi Hartono',
                'total_amount' => 180000.00,
                'items' => json_encode([
                    ['name' => 'Smartwatch Apple', 'qty' => 1, 'price' => 180000.00]
                ]),
                'status' => 'cancelled',
                'processed' => false,
                'created_at' => now()->subHours(1),
                'updated_at' => now()->subHours(1)
            ],
            [
                'order_id' => 'ORD-006',
                'customer_name' => 'Maya Sari',
                'total_amount' => 95000.00,
                'items' => json_encode([
                    ['name' => 'Wireless Mouse', 'qty' => 2, 'price' => 47500.00]
                ]),
                'status' => 'pending',
                'processed' => false,
                'created_at' => now()->subMinutes(30),
                'updated_at' => now()->subMinutes(30)
            ],
            [
                'order_id' => 'ORD-007',
                'customer_name' => 'Joko Widodo',
                'total_amount' => 450000.00,
                'items' => json_encode([
                    ['name' => 'Gaming Laptop', 'qty' => 1, 'price' => 450000.00]
                ]),
                'status' => 'processing',
                'processed' => false,
                'created_at' => now()->subMinutes(15),
                'updated_at' => now()->subMinutes(15)
            ]
        ];
        
        // Insert sample data
        DB::table('orders')->insert($sampleOrders);
        
        echo "<p style='color: green;'>✅ Sample data berhasil ditambahkan!</p>";
        echo "<p>📊 Total data: " . DB::table('orders')->count() . " records</p>";
        
        // Show the created data
        echo "<h3>📋 Data yang Baru Dibuat:</h3>";
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr style='background-color: #f0f0f0;'>";
        echo "<th>ID</th><th>Order ID</th><th>Customer</th><th>Amount</th><th>Status</th><th>Created</th>";
        echo "</tr>";
        
        $newData = DB::table('orders')->orderBy('created_at', 'desc')->get();
        foreach ($newData as $order) {
            echo "<tr>";
            echo "<td>{$order->id}</td>";
            echo "<td>{$order->order_id}</td>";
            echo "<td>{$order->customer_name}</td>";
            echo "<td>Rp " . number_format($order->total_amount, 0, ',', '.') . "</td>";
            echo "<td>{$order->status}</td>";
            echo "<td>{$order->created_at}</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    echo "<h3>🎯 Cara Menggunakan Baden Endpoint:</h3>";
    echo "<div style='background-color: #f8f9fa; padding: 15px; border-radius: 5px;'>";
    echo "<p><strong>URL:</strong> https://copilotproduction.site/api/in/baden</p>";
    echo "<p><strong>Method:</strong> GET</p>";
    echo "<p><strong>Authentication:</strong> Basic Auth (username: baden, password: baden)</p>";
    echo "<p><strong>Header:</strong> Authorization: Basic YmFkZW46YmFkZW4=</p>";
    echo "</div>";
    
    echo "<h3>📝 Contoh cURL:</h3>";
    echo "<div style='background-color: #f8f9fa; padding: 15px; border-radius: 5px; font-family: monospace;'>";
    echo "curl -X GET \"https://copilotproduction.site/api/in/baden\" \\<br>";
    echo "  -H \"Authorization: Basic YmFkZW46YmFkZW4=\" \\<br>";
    echo "  -H \"Content-Type: application/json\"";
    echo "</div>";
    
    echo "<h3>🔗 Test Links:</h3>";
    echo "<p><a href='test-baden-get.html' target='_blank'>🧪 Test Baden GET Endpoint</a></p>";
    echo "<p><a href='https://copilotproduction.site/api/in/baden' target='_blank'>🌐 Direct API Call</a></p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>
