<?php

// Script debug khusus untuk endpoint baden
echo "=== DEBUG ENDPOINT BADEN ===\n";

// 1. Check request details
echo "1. Request Analysis:\n";
echo "   Method: " . $_SERVER['REQUEST_METHOD'] . "\n";
echo "   URL: " . $_SERVER['REQUEST_URI'] . "\n";
echo "   Content-Type: " . ($_SERVER['CONTENT_TYPE'] ?? 'Not set') . "\n";
echo "   Accept: " . ($_SERVER['HTTP_ACCEPT'] ?? 'Not set') . "\n";

// 2. Bootstrap Laravel
echo "\n2. Laravel Bootstrap:\n";
try {
    require_once __DIR__ . '/../vendor/autoload.php';
    $app = require_once __DIR__ . '/../bootstrap/app.php';
    $app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();
    echo "   ✅ Laravel bootstrapped successfully\n";
    
    // 3. Check endpoint baden
    echo "\n3. Endpoint Baden Check:\n";
    
    try {
        $db = app('db');
        $receiver = $db->table('api_receivers')
            ->where('endpoint', 'baden')
            ->first();
        
        if ($receiver) {
            echo "   ✅ Receiver 'baden' found\n";
            echo "   📊 Name: " . $receiver->name . "\n";
            echo "   📊 Target table: " . $receiver->target_table . "\n";
            echo "   🔧 Auto create: " . ($receiver->auto_create_table ? 'Yes' : 'No') . "\n";
            echo "   ✅ Is active: " . ($receiver->is_active ? 'Yes' : 'No') . "\n";
            echo "   📝 Response format: " . $receiver->response_format . "\n";
            
            // 4. Check table existence
            echo "\n4. Table Status:\n";
            $schema = app('schema');
            $tableExists = $schema->hasTable($receiver->target_table);
            echo "   Table exists: " . ($tableExists ? 'Yes' : 'No') . "\n";
            
            if ($tableExists) {
                // Get table structure
                $columns = $schema->getColumnListing($receiver->target_table);
                echo "   Columns: " . implode(', ', $columns) . "\n";
                
                // Check data count
                $count = $db->table($receiver->target_table)->count();
                echo "   Total records: $count\n";
                
                // Get sample data
                $sampleData = $db->table($receiver->target_table)
                    ->limit(3)
                    ->get();
                
                if ($sampleData->count() > 0) {
                    echo "   Sample data:\n";
                    foreach ($sampleData as $record) {
                        echo "   - ID: " . $record->id . ", Nama: " . ($record->nama ?? 'N/A') . "\n";
                    }
                } else {
                    echo "   No data in table\n";
                }
            } else {
                echo "   Table does not exist\n";
            }
            
            // 5. Test GET response generation
            echo "\n5. GET Response Test:\n";
            
            // Simulate GET request data
            $testData = [
                'receiver_info' => [
                    'id' => $receiver->id,
                    'name' => $receiver->name,
                    'endpoint' => $receiver->endpoint,
                    'description' => $receiver->description
                ],
                'request_info' => [
                    'method' => 'GET',
                    'received_at' => now()->toISOString(),
                    'ip_address' => '127.0.0.1',
                    'user_agent' => 'Test Agent'
                ],
                'parameters' => [],
                'pagination' => [
                    'limit' => 10,
                    'offset' => 0,
                    'sort' => 'id',
                    'order' => 'desc'
                ]
            ];
            
            if ($tableExists) {
                $records = $db->table($receiver->target_table)
                    ->orderBy('id', 'desc')
                    ->limit(5)
                    ->get();
                
                $testData['data'] = [
                    'total_records' => $db->table($receiver->target_table)->count(),
                    'returned_records' => $records->count(),
                    'records' => $records->toArray()
                ];
            } else {
                $testData['data'] = [
                    'message' => 'No data source configured or table does not exist'
                ];
            }
            
            // Test response formatting
            $response = [
                'success' => true,
                'message' => 'Data retrieved successfully',
                'received_at' => now()->toISOString()
            ];
            
            if (isset($testData['data']) && isset($testData['data']['records'])) {
                $response['data'] = $testData['data']['records'];
                $response['total_records'] = $testData['data']['total_records'] ?? 0;
            } elseif (isset($testData['data'])) {
                $response['data'] = $testData['data'];
            } else {
                $response['data'] = [
                    'receiver_name' => $testData['receiver_info']['name'] ?? 'Unknown',
                    'endpoint' => $testData['receiver_info']['endpoint'] ?? 'Unknown',
                    'message' => 'No data available'
                ];
            }
            
            echo "   Response structure:\n";
            echo "   - success: " . ($response['success'] ? 'true' : 'false') . "\n";
            echo "   - message: " . $response['message'] . "\n";
            echo "   - received_at: " . $response['received_at'] . "\n";
            
            if (isset($response['data'])) {
                if (is_array($response['data'])) {
                    echo "   - data: Array with " . count($response['data']) . " items\n";
                } else {
                    echo "   - data: " . json_encode($response['data']) . "\n";
                }
            }
            
            if (isset($response['total_records'])) {
                echo "   - total_records: " . $response['total_records'] . "\n";
            }
            
            // 6. Test JSON encoding
            echo "\n6. JSON Encoding Test:\n";
            $jsonResponse = json_encode($response, JSON_PRETTY_PRINT);
            if (json_last_error() === JSON_ERROR_NONE) {
                echo "   ✅ JSON encoding successful\n";
                echo "   Response size: " . strlen($jsonResponse) . " bytes\n";
                echo "   Sample response:\n";
                echo "   " . substr($jsonResponse, 0, 500) . "...\n";
            } else {
                echo "   ❌ JSON encoding failed: " . json_last_error_msg() . "\n";
            }
            
        } else {
            echo "   ❌ Receiver 'baden' not found\n";
            
            // Show available receivers
            $receivers = $db->table('api_receivers')
                ->where('is_active', true)
                ->select('endpoint', 'name')
                ->limit(10)
                ->get();
            
            echo "   💡 Available active receivers:\n";
            foreach ($receivers as $rec) {
                echo "      - {$rec->endpoint} ({$rec->name})\n";
            }
        }
        
    } catch (Exception $e) {
        echo "   ❌ Database error: " . $e->getMessage() . "\n";
    }
    
} catch (Exception $e) {
    echo "   ❌ Laravel bootstrap failed: " . $e->getMessage() . "\n";
}

// 7. Generate test response
echo "\n7. Test Response Output:\n";
$testResponse = [
    'success' => true,
    'message' => 'Debug response for endpoint baden',
    'received_at' => date('c'),
    'data' => [
        'endpoint' => 'baden',
        'status' => 'debug_mode',
        'timestamp' => date('Y-m-d H:i:s')
    ]
];

// Set headers
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Output JSON response
echo json_encode($testResponse, JSON_PRETTY_PRINT);

echo "\n=== END DEBUG ===\n";
