<?php

// Script debug untuk mengecek response Postman
echo "=== DEBUG POSTMAN RESPONSE ===\n";

// 1. Check request details
echo "1. Request Analysis:\n";
echo "   Method: " . $_SERVER['REQUEST_METHOD'] . "\n";
echo "   URL: " . $_SERVER['REQUEST_URI'] . "\n";
echo "   Content-Type: " . ($_SERVER['CONTENT_TYPE'] ?? 'Not set') . "\n";
echo "   Accept: " . ($_SERVER['HTTP_ACCEPT'] ?? 'Not set') . "\n";

// 2. Check body data
$bodyData = file_get_contents('php://input');
echo "   Body data exists: " . (!empty($bodyData) ? 'Yes' : 'No') . "\n";
echo "   Body size: " . strlen($bodyData) . " bytes\n";

if (!empty($bodyData)) {
    echo "   Body content: " . substr($bodyData, 0, 200) . "\n";
    
    // Try to parse JSON
    $jsonData = json_decode($bodyData, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        echo "   ✅ JSON is valid\n";
        echo "   JSON keys: " . implode(', ', array_keys($jsonData)) . "\n";
    } else {
        echo "   ❌ JSON error: " . json_last_error_msg() . "\n";
    }
}

// 3. Bootstrap Laravel
echo "\n2. Laravel Bootstrap:\n";
try {
    require_once __DIR__ . '/../vendor/autoload.php';
    $app = require_once __DIR__ . '/../bootstrap/app.php';
    $app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();
    echo "   ✅ Laravel bootstrapped successfully\n";
    
    // 4. Test API endpoint
    echo "\n3. API Endpoint Test:\n";
    
    // Extract endpoint from URL
    $path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
    $endpoint = basename($path);
    echo "   Endpoint: $endpoint\n";
    
    // Check if endpoint exists in database
    try {
        $db = app('db');
        $receiver = $db->table('api_receivers')
            ->where('endpoint', $endpoint)
            ->where('is_active', true)
            ->first();
        
        if ($receiver) {
            echo "   ✅ Receiver found: " . $receiver->name . "\n";
            echo "   📊 Target table: " . $receiver->target_table . "\n";
            echo "   🔧 Auto create: " . ($receiver->auto_create_table ? 'Yes' : 'No') . "\n";
            
            // 5. Test response generation
            echo "\n4. Response Generation Test:\n";
            
            // Simulate the response
            $response = [
                'success' => true,
                'message' => 'Data received successfully',
                'received_at' => now()->toISOString(),
                'data' => !empty($jsonData) ? $jsonData : ['test' => 'data']
            ];
            
            echo "   Response structure:\n";
            echo "   - success: " . ($response['success'] ? 'true' : 'false') . "\n";
            echo "   - message: " . $response['message'] . "\n";
            echo "   - received_at: " . $response['received_at'] . "\n";
            echo "   - data keys: " . implode(', ', array_keys($response['data'])) . "\n";
            
            // 6. Test JSON encoding
            echo "\n5. JSON Encoding Test:\n";
            $jsonResponse = json_encode($response, JSON_PRETTY_PRINT);
            if (json_last_error() === JSON_ERROR_NONE) {
                echo "   ✅ JSON encoding successful\n";
                echo "   Response size: " . strlen($jsonResponse) . " bytes\n";
                echo "   Sample response:\n";
                echo "   " . substr($jsonResponse, 0, 300) . "...\n";
            } else {
                echo "   ❌ JSON encoding failed: " . json_last_error_msg() . "\n";
            }
            
        } else {
            echo "   ❌ Receiver '$endpoint' not found or inactive\n";
            
            // Show available receivers
            $receivers = $db->table('api_receivers')
                ->where('is_active', true)
                ->select('endpoint', 'name')
                ->limit(5)
                ->get();
            
            echo "   💡 Available active receivers:\n";
            foreach ($receivers as $rec) {
                echo "      - {$rec->endpoint} ({$rec->name})\n";
            }
        }
        
    } catch (Exception $e) {
        echo "   ❌ Database error: " . $e->getMessage() . "\n";
    }
    
} catch (Exception $e) {
    echo "   ❌ Laravel bootstrap failed: " . $e->getMessage() . "\n";
}

// 7. Check headers
echo "\n6. Response Headers Test:\n";
echo "   Setting Content-Type: application/json\n";
echo "   Setting Access-Control-Allow-Origin: *\n";

// 8. Generate test response
echo "\n7. Test Response Output:\n";
$testResponse = [
    'success' => true,
    'message' => 'Debug response from Postman test',
    'received_at' => date('c'),
    'data' => [
        'method' => $_SERVER['REQUEST_METHOD'],
        'endpoint' => basename(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH)),
        'body_data' => !empty($jsonData) ? $jsonData : null,
        'headers' => [
            'content_type' => $_SERVER['CONTENT_TYPE'] ?? 'Not set',
            'accept' => $_SERVER['HTTP_ACCEPT'] ?? 'Not set'
        ]
    ]
];

// Set headers
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Output JSON response
echo json_encode($testResponse, JSON_PRETTY_PRINT);

echo "\n=== END DEBUG ===\n";
