<?php

// Script debug untuk hosting
echo "=== HOSTING DEBUG SCRIPT ===\n";

// 1. Check PHP version and extensions
echo "1. PHP Environment:\n";
echo "   PHP Version: " . phpversion() . "\n";
echo "   PDO MySQL: " . (extension_loaded('pdo_mysql') ? '✅' : '❌') . "\n";
echo "   JSON: " . (extension_loaded('json') ? '✅' : '❌') . "\n";
echo "   Fileinfo: " . (extension_loaded('fileinfo') ? '✅' : '❌') . "\n";

// 2. Check Laravel files
echo "\n2. Laravel Files:\n";
$laravelFiles = [
    '../vendor/autoload.php',
    '../bootstrap/app.php',
    '../config/database.php',
    '../.env'
];

foreach ($laravelFiles as $file) {
    echo "   " . $file . ": " . (file_exists($file) ? '✅' : '❌') . "\n";
}

// 3. Try to bootstrap Laravel
echo "\n3. Laravel Bootstrap:\n";
try {
    require_once __DIR__ . '/../vendor/autoload.php';
    $app = require_once __DIR__ . '/../bootstrap/app.php';
    $app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();
    echo "   ✅ Laravel bootstrapped successfully\n";
    
    // 4. Check database connection
    echo "\n4. Database Connection:\n";
    try {
        $pdo = new PDO(
            'mysql:host=' . env('DB_HOST', 'localhost') . 
            ';dbname=' . env('DB_DATABASE', 'database') . 
            ';charset=utf8mb4',
            env('DB_USERNAME', 'root'),
            env('DB_PASSWORD', '')
        );
        echo "   ✅ Database connection successful\n";
        
        // 5. Check if api_receivers table exists
        echo "\n5. Database Tables:\n";
        $tables = ['api_receivers', 'api_receive_logs', 'ujicoba'];
        
        foreach ($tables as $table) {
            $stmt = $pdo->query("SHOW TABLES LIKE '$table'");
            $exists = $stmt->rowCount() > 0;
            echo "   $table: " . ($exists ? '✅' : '❌') . "\n";
        }
        
        // 6. Check receiver configuration
        echo "\n6. Receiver Configuration:\n";
        $stmt = $pdo->query("SELECT endpoint, name, target_table, auto_create_table, is_active FROM api_receivers WHERE endpoint = 'ujicoba'");
        $receiver = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($receiver) {
            echo "   ✅ Receiver found: " . $receiver['name'] . "\n";
            echo "   📊 Target table: " . $receiver['target_table'] . "\n";
            echo "   🔧 Auto create: " . ($receiver['auto_create_table'] ? 'Yes' : 'No') . "\n";
            echo "   ✅ Is active: " . ($receiver['is_active'] ? 'Yes' : 'No') . "\n";
        } else {
            echo "   ❌ Receiver 'ujicoba' not found\n";
            
            // Show available receivers
            $stmt = $pdo->query("SELECT endpoint, name, is_active FROM api_receivers LIMIT 5");
            $receivers = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo "   💡 Available receivers:\n";
            foreach ($receivers as $rec) {
                $status = $rec['is_active'] ? '✅' : '❌';
                echo "      $status {$rec['endpoint']} ({$rec['name']})\n";
            }
        }
        
        // 7. Check recent logs
        echo "\n7. Recent API Logs:\n";
        $stmt = $pdo->query("SELECT method, status_code, saved_to_table, save_error, created_at FROM api_receive_logs ORDER BY created_at DESC LIMIT 3");
        $logs = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        if ($logs) {
            foreach ($logs as $log) {
                $saved = $log['saved_to_table'] ? '✅' : '❌';
                echo "   {$log['created_at']} | {$log['method']} | Status: {$log['status_code']} | Saved: $saved\n";
                if ($log['save_error']) {
                    echo "      Error: {$log['save_error']}\n";
                }
            }
        } else {
            echo "   📝 No recent logs found\n";
        }
        
    } catch (PDOException $e) {
        echo "   ❌ Database connection failed: " . $e->getMessage() . "\n";
        echo "   💡 Check your .env file database configuration\n";
    }
    
} catch (Exception $e) {
    echo "   ❌ Laravel bootstrap failed: " . $e->getMessage() . "\n";
}

echo "\n=== END HOSTING DEBUG ===\n"; 