<?php

// Script debugging untuk GET dengan body data di hosting
echo "=== HOSTING GET DEBUG ===\n";

// 1. Check request method and body
echo "1. Request Analysis:\n";
echo "   Method: " . $_SERVER['REQUEST_METHOD'] . "\n";
echo "   Content-Type: " . ($_SERVER['CONTENT_TYPE'] ?? 'Not set') . "\n";
echo "   Content-Length: " . ($_SERVER['CONTENT_LENGTH'] ?? 'Not set') . "\n";

// 2. Check if there's body data
$bodyData = file_get_contents('php://input');
echo "   Body data exists: " . (!empty($bodyData) ? 'Yes' : 'No') . "\n";
echo "   Body size: " . strlen($bodyData) . " bytes\n";

if (!empty($bodyData)) {
    echo "   Body content: " . substr($bodyData, 0, 200) . "\n";
    
    // Try to parse JSON
    $jsonData = json_decode($bodyData, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        echo "   ✅ JSON is valid\n";
        echo "   JSON keys: " . implode(', ', array_keys($jsonData)) . "\n";
    } else {
        echo "   ❌ JSON error: " . json_last_error_msg() . "\n";
    }
}

// 3. Try to bootstrap Laravel
echo "\n2. Laravel Bootstrap:\n";
try {
    require_once __DIR__ . '/../vendor/autoload.php';
    $app = require_once __DIR__ . '/../bootstrap/app.php';
    $app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();
    echo "   ✅ Laravel bootstrapped successfully\n";
    
    // Use Laravel facades
    $db = app('db');
    $schema = app('schema');
    $log = app('log');
    
    // 4. Check database connection
    echo "\n3. Database Connection:\n";
    try {
        $pdo = new PDO(
            'mysql:host=' . env('DB_HOST', 'localhost') . 
            ';dbname=' . env('DB_DATABASE', 'database') . 
            ';charset=utf8mb4',
            env('DB_USERNAME', 'root'),
            env('DB_PASSWORD', '')
        );
        echo "   ✅ Database connection successful\n";
        
        // 5. Check receiver configuration
        echo "\n4. Receiver Configuration:\n";
        $endpoint = 'ujicoba'; // Change this to your endpoint
        
        $stmt = $pdo->query("SELECT endpoint, name, target_table, auto_create_table, is_active FROM api_receivers WHERE endpoint = '$endpoint'");
        $receiver = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($receiver) {
            echo "   ✅ Receiver found: " . $receiver['name'] . "\n";
            echo "   📊 Target table: " . $receiver['target_table'] . "\n";
            echo "   🔧 Auto create: " . ($receiver['auto_create_table'] ? 'Yes' : 'No') . "\n";
            echo "   ✅ Is active: " . ($receiver['is_active'] ? 'Yes' : 'No') . "\n";
            
            // 6. Check table existence
            echo "\n5. Table Status:\n";
            $stmt = $pdo->query("SHOW TABLES LIKE '{$receiver['target_table']}'");
            $tableExists = $stmt->rowCount() > 0;
            echo "   Table exists: " . ($tableExists ? 'Yes' : 'No') . "\n";
            
            if ($tableExists) {
                // Get table structure
                $stmt = $pdo->query("DESCRIBE {$receiver['target_table']}");
                $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);
                echo "   Columns: " . implode(', ', array_column($columns, 'Field')) . "\n";
            }
            
            // 7. Test manual data insertion
            if (!empty($bodyData) && json_last_error() === JSON_ERROR_NONE) {
                echo "\n6. Testing Manual Data Insertion:\n";
                
                $testData = [
                    'external_id' => 999,
                    'nama' => 'Test from GET Debug',
                    'alamat' => 'Test Address',
                    'gender' => 'male',
                    'data' => json_encode(['test' => 'value']),
                    'created_at' => date('Y-m-d H:i:s'),
                    'updated_at' => date('Y-m-d H:i:s')
                ];
                
                try {
                    if (!$tableExists && $receiver['auto_create_table']) {
                        echo "   📋 Creating table...\n";
                        $createSQL = "CREATE TABLE {$receiver['target_table']} (
                            id INT AUTO_INCREMENT PRIMARY KEY,
                            external_id INT NULL,
                            nama VARCHAR(255) NULL,
                            alamat VARCHAR(255) NULL,
                            gender VARCHAR(50) NULL,
                            data JSON NULL,
                            created_at TIMESTAMP NULL,
                            updated_at TIMESTAMP NULL
                        )";
                        $pdo->exec($createSQL);
                        echo "   ✅ Table created\n";
                    }
                    
                    // Insert test data
                    $columns = implode(', ', array_keys($testData));
                    $values = "'" . implode("', '", array_values($testData)) . "'";
                    $sql = "INSERT INTO {$receiver['target_table']} ($columns) VALUES ($values)";
                    
                    $result = $pdo->exec($sql);
                    if ($result !== false) {
                        echo "   ✅ Test data inserted successfully\n";
                        echo "   📊 Rows affected: $result\n";
                    } else {
                        echo "   ❌ Failed to insert test data\n";
                        $error = $pdo->errorInfo();
                        echo "   Error: " . $error[2] . "\n";
                    }
                    
                } catch (Exception $e) {
                    echo "   ❌ Error during test insertion: " . $e->getMessage() . "\n";
                }
            }
            
        } else {
            echo "   ❌ Receiver '$endpoint' not found\n";
            
            // Show available receivers
            $stmt = $pdo->query("SELECT endpoint, name, is_active FROM api_receivers LIMIT 5");
            $receivers = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo "   💡 Available receivers:\n";
            foreach ($receivers as $rec) {
                $status = $rec['is_active'] ? '✅' : '❌';
                echo "      $status {$rec['endpoint']} ({$rec['name']})\n";
            }
        }
        
    } catch (PDOException $e) {
        echo "   ❌ Database connection failed: " . $e->getMessage() . "\n";
        echo "   💡 Check your .env file database configuration\n";
    }
    
} catch (Exception $e) {
    echo "   ❌ Laravel bootstrap failed: " . $e->getMessage() . "\n";
}

// 8. Check recent logs
echo "\n7. Recent API Logs:\n";
try {
    $logFile = '../storage/logs/laravel.log';
    if (file_exists($logFile)) {
        $lines = file($logFile);
        $lastLines = array_slice($lines, -10);
        
        echo "   📝 Last 10 log entries:\n";
        foreach ($lastLines as $line) {
            if (strpos($line, 'GET') !== false || strpos($line, 'ujicoba') !== false) {
                echo "   " . trim($line) . "\n";
            }
        }
    } else {
        echo "   📝 Log file not found\n";
    }
} catch (Exception $e) {
    echo "   ❌ Error reading logs: " . $e->getMessage() . "\n";
}

echo "\n=== END HOSTING GET DEBUG ===\n"; 