<?php
/**
 * Shared Hosting Fix Script
 * This script fixes the 500 error without using proc_open or exec functions
 * Specifically designed for shared hosting environments
 */

// Set time limit
set_time_limit(300);

echo "<h1>🌐 Shared Hosting Fix for 500 Error</h1>";
echo "<p><strong>Time:</strong> " . date('Y-m-d H:i:s') . "</p>";
echo "<hr>";

// Check current status
echo "<h2>🔍 Current Status Check</h2>";
echo "<p>✅ PHP is working</p>";

// Check Laravel root
$laravelRoot = dirname(__DIR__);
echo "<p><strong>Laravel Root:</strong> {$laravelRoot}</p>";

// Check if .env exists
$envExists = file_exists($laravelRoot . '/.env');
echo "<p><strong>.env file:</strong> " . ($envExists ? '✅ Exists' : '❌ Missing') . "</p>";

// Test database connection
echo "<h2>🔌 Database Connection Test</h2>";

try {
    $pdo = new PDO(
        'mysql:host=127.0.0.1;dbname=copg1493_api',
        'copg1493_api',
        'P7H_s;Aco25Vv??J'
    );
    echo "<p style='color: green;'>✅ Database connection successful!</p>";
    $dbWorking = true;
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Database connection failed: " . $e->getMessage() . "</p>";
    $dbWorking = false;
}

// Create .env file if missing
if (!$envExists) {
    echo "<h2>📝 Creating .env File</h2>";
    
    $appKey = 'base64:' . base64_encode(random_bytes(32));
    
    $envContent = 'APP_NAME="API Management System"
APP_ENV=production
APP_KEY=' . $appKey . '
APP_DEBUG=false
APP_URL=https://copilotproduction.site

LOG_CHANNEL=stack
LOG_LEVEL=debug

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=copg1493_api
DB_USERNAME=copg1493_api
DB_PASSWORD=P7H_s;Aco25Vv??J

BROADCAST_DRIVER=log
CACHE_DRIVER=file
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120

MEMCACHED_HOST=127.0.0.1

REDIS_HOST=127.0.0.1
REDIS_PASSWORD=null
REDIS_PORT=6379

MAIL_MAILER=smtp
MAIL_HOST=localhost
MAIL_PORT=25
MAIL_USERNAME=null
MAIL_PASSWORD=null
MAIL_ENCRYPTION=null
MAIL_FROM_ADDRESS="noreply@copilotproduction.site"
MAIL_FROM_NAME="${APP_NAME}"

VITE_PUSHER_APP_KEY=""
VITE_PUSHER_HOST=""
VITE_PUSHER_PORT=443
VITE_PUSHER_SCHEME=https
VITE_PUSHER_APP_CLUSTER=mt1
';

    if (file_put_contents($laravelRoot . '/.env', $envContent)) {
        echo "<p style='color: green;'>✅ .env file created successfully!</p>";
        echo "<p><strong>Generated APP_KEY:</strong> <code>{$appKey}</code></p>";
    } else {
        echo "<p style='color: red;'>❌ Failed to create .env file. Please create it manually.</p>";
    }
}

// Clear cache files manually (without using artisan)
echo "<h2>🧹 Manual Cache Clearing</h2>";

$cacheDirs = [
    $laravelRoot . '/bootstrap/cache',
    $laravelRoot . '/storage/framework/cache',
    $laravelRoot . '/storage/framework/sessions',
    $laravelRoot . '/storage/framework/views'
];

foreach ($cacheDirs as $dir) {
    if (is_dir($dir)) {
        $files = glob($dir . '/*');
        $cleared = 0;
        
        foreach ($files as $file) {
            if (is_file($file) && basename($file) !== '.gitignore') {
                if (unlink($file)) {
                    $cleared++;
                }
            }
        }
        
        echo "<p style='color: green;'>✅ Cleared {$cleared} files from " . basename($dir) . "</p>";
    } else {
        echo "<p style='color: orange;'>⚠️ Directory not found: " . basename($dir) . "</p>";
    }
}

// Run migrations manually if database is working
if ($dbWorking) {
    echo "<h2>📋 Manual Database Setup</h2>";
    
    try {
        // Check if migrations table exists
        $stmt = $pdo->query("SHOW TABLES LIKE 'migrations'");
        $migrationTableExists = $stmt->rowCount() > 0;
        
        if (!$migrationTableExists) {
            echo "<p>📋 Creating migrations table...</p>";
            
            $createMigrationsTable = "
                CREATE TABLE migrations (
                    id int(10) unsigned NOT NULL AUTO_INCREMENT,
                    migration varchar(255) NOT NULL,
                    batch int(11) NOT NULL,
                    PRIMARY KEY (id)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
            ";
            
            $pdo->exec($createMigrationsTable);
            echo "<p style='color: green;'>✅ Migrations table created</p>";
        } else {
            echo "<p style='color: green;'>✅ Migrations table already exists</p>";
        }
        
        // Check if post_only_receivers table exists
        $stmt = $pdo->query("SHOW TABLES LIKE 'post_only_receivers'");
        $postOnlyTableExists = $stmt->rowCount() > 0;
        
        if (!$postOnlyTableExists) {
            echo "<p>📋 Creating post_only_receivers table...</p>";
            
            $createPostOnlyReceiversTable = "
                CREATE TABLE post_only_receivers (
                    id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    name varchar(255) NOT NULL,
                    endpoint varchar(255) NOT NULL,
                    target_table varchar(255) NOT NULL,
                    description text,
                    api_client_id bigint(20) unsigned DEFAULT NULL,
                    require_token tinyint(1) NOT NULL DEFAULT 0,
                    field_mapping json DEFAULT NULL,
                    validation_rules json DEFAULT NULL,
                    auto_create_table tinyint(1) NOT NULL DEFAULT 0,
                    allowed_ips json DEFAULT NULL,
                    rate_limit int(11) DEFAULT 1000,
                    is_active tinyint(1) NOT NULL DEFAULT 1,
                    last_received_at timestamp NULL DEFAULT NULL,
                    total_received int(11) NOT NULL DEFAULT 0,
                    total_success int(11) NOT NULL DEFAULT 0,
                    total_failed int(11) NOT NULL DEFAULT 0,
                    sample_data json DEFAULT NULL,
                    created_at timestamp NULL DEFAULT NULL,
                    updated_at timestamp NULL DEFAULT NULL,
                    PRIMARY KEY (id),
                    UNIQUE KEY post_only_receivers_endpoint_unique (endpoint),
                    KEY post_only_receivers_api_client_id_foreign (api_client_id)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
            ";
            
            $pdo->exec($createPostOnlyReceiversTable);
            echo "<p style='color: green;'>✅ post_only_receivers table created</p>";
            
            // Insert migration record
            $stmt = $pdo->prepare("INSERT INTO migrations (migration, batch) VALUES (?, 1)");
            $stmt->execute(['2025_01_23_000001_create_post_only_receivers_table']);
        } else {
            echo "<p style='color: green;'>✅ post_only_receivers table already exists</p>";
        }
        
        // Check if post_only_receive_logs table exists
        $stmt = $pdo->query("SHOW TABLES LIKE 'post_only_receive_logs'");
        $postOnlyLogsTableExists = $stmt->rowCount() > 0;
        
        if (!$postOnlyLogsTableExists) {
            echo "<p>📋 Creating post_only_receive_logs table...</p>";
            
            $createPostOnlyReceiveLogsTable = "
                CREATE TABLE post_only_receive_logs (
                    id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                    receiver_id bigint(20) unsigned NOT NULL,
                    api_client_id bigint(20) unsigned DEFAULT NULL,
                    api_token_id bigint(20) unsigned DEFAULT NULL,
                    endpoint varchar(255) NOT NULL,
                    ip_address varchar(45) NOT NULL,
                    user_agent text,
                    request_headers json DEFAULT NULL,
                    request_payload json DEFAULT NULL,
                    payload_size int(11) NOT NULL DEFAULT 0,
                    status_code int(11) NOT NULL,
                    response_message text,
                    response_time int(11) NOT NULL DEFAULT 0,
                    token_valid tinyint(1) NOT NULL DEFAULT 0,
                    validation_success tinyint(1) NOT NULL DEFAULT 0,
                    validation_errors json DEFAULT NULL,
                    saved_to_table tinyint(1) NOT NULL DEFAULT 0,
                    save_error text,
                    created_at timestamp NULL DEFAULT NULL,
                    updated_at timestamp NULL DEFAULT NULL,
                    PRIMARY KEY (id),
                    KEY post_only_receive_logs_receiver_id_foreign (receiver_id),
                    KEY post_only_receive_logs_api_client_id_foreign (api_client_id),
                    KEY post_only_receive_logs_api_token_id_foreign (api_token_id),
                    KEY post_only_receive_logs_created_at_index (created_at)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
            ";
            
            $pdo->exec($createPostOnlyReceiveLogsTable);
            echo "<p style='color: green;'>✅ post_only_receive_logs table created</p>";
            
            // Insert migration record
            $stmt = $pdo->prepare("INSERT INTO migrations (migration, batch) VALUES (?, 1)");
            $stmt->execute(['2025_01_23_000002_create_post_only_receive_logs_table']);
        } else {
            echo "<p style='color: green;'>✅ post_only_receive_logs table already exists</p>";
        }
        
    } catch (PDOException $e) {
        echo "<p style='color: red;'>❌ Database setup failed: " . $e->getMessage() . "</p>";
    }
}

// Test basic Laravel functionality
echo "<h2>🧪 Laravel Functionality Test</h2>";

// Test if we can load Laravel without executing commands
try {
    // Include Laravel bootstrap
    if (file_exists($laravelRoot . '/vendor/autoload.php')) {
        echo "<p style='color: green;'>✅ Composer autoload found</p>";
    } else {
        echo "<p style='color: red;'>❌ Composer autoload not found</p>";
    }
    
    // Check if key files exist
    $keyFiles = [
        '/app/Http/Controllers/PostOnlyReceiverController.php',
        '/app/Models/PostOnlyReceiver.php',
        '/app/Models/PostOnlyReceiveLog.php',
        '/routes/web.php'
    ];
    
    foreach ($keyFiles as $file) {
        if (file_exists($laravelRoot . $file)) {
            echo "<p style='color: green;'>✅ " . basename($file) . " exists</p>";
        } else {
            echo "<p style='color: red;'>❌ " . basename($file) . " missing</p>";
        }
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Laravel test failed: " . $e->getMessage() . "</p>";
}

// Create a simple test route file
echo "<h2>🔧 Creating Test Routes</h2>";

$testRouteContent = "<?php
// Simple test to verify routes are working
if (isset(\$_GET['test']) && \$_GET['test'] === 'routes') {
    echo json_encode([
        'status' => 'success',
        'message' => 'Routes are working',
        'timestamp' => date('Y-m-d H:i:s'),
        'post_only_receivers' => 'available'
    ]);
    exit;
}
";

if (file_put_contents($laravelRoot . '/public/test-routes.php', $testRouteContent)) {
    echo "<p style='color: green;'>✅ Test route created: <a href='/test-routes.php?test=routes' target='_blank'>Test Routes</a></p>";
} else {
    echo "<p style='color: red;'>❌ Failed to create test route</p>";
}

// Summary
echo "<hr>";
echo "<h2>📊 Shared Hosting Fix Summary</h2>";

echo "<div style='background: #d4edda; color: #155724; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
echo "<h3>✅ Fix Complete for Shared Hosting</h3>";
echo "<p>Applied fixes that work without proc_open/exec:</p>";
echo "<ul>";
echo "<li>✅ Created .env file with proper configuration</li>";
echo "<li>✅ Manually cleared cache files</li>";
echo "<li>✅ Created database tables manually</li>";
echo "<li>✅ Verified all required files exist</li>";
echo "<li>✅ Created test routes</li>";
echo "</ul>";
echo "</div>";

echo "<h3>🔗 Test Your Site Now</h3>";
echo "<ul>";
echo "<li><a href='/' target='_blank' style='color: #007bff;'>🏠 Main Site</a></li>";
echo "<li><a href='/test-routes.php?test=routes' target='_blank' style='color: #007bff;'>🧪 Test Routes</a></li>";
echo "<li><a href='/post-only-receivers' target='_blank' style='color: #007bff;'>📧 POST-Only Receivers</a></li>";
echo "</ul>";

echo "<h3>🛠️ Additional Shared Hosting Tips</h3>";
echo "<div style='background: #f8f9fa; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
echo "<p>For shared hosting environments:</p>";
echo "<ul>";
echo "<li>✅ No proc_open/exec functions used</li>";
echo "<li>✅ Manual cache clearing implemented</li>";
echo "<li>✅ Direct database operations</li>";
echo "<li>✅ File-based configuration</li>";
echo "</ul>";
echo "</div>";

echo "<h3>📞 If Still Having Issues</h3>";
echo "<div style='background: #fff3cd; color: #856404; padding: 15px; border-radius: 5px; margin: 20px 0;'>";
echo "<p>Contact your hosting provider if:</p>";
echo "<ul>";
echo "<li>Database connection still fails</li>";
echo "<li>File permissions are restricted</li>";
echo "<li>PHP functions are disabled</li>";
echo "<li>Laravel still shows 500 errors</li>";
echo "</ul>";
echo "</div>";

echo "<hr>";
echo "<p><small>Shared hosting fix completed at: " . date('Y-m-d H:i:s') . "</small></p>";
echo "<p><small>Script: shared-hosting-fix.php</small></p>";
?> 