<?php
/**
 * Simple Fix Script - No System Calls
 * Works on any shared hosting environment
 */

echo "<h1>🔧 Simple Fix (No System Calls)</h1>";
echo "<p><strong>Time:</strong> " . date('Y-m-d H:i:s') . "</p>";
echo "<hr>";

// Basic status
echo "<h2>✅ Basic Status Check</h2>";
echo "<p>✅ PHP Version: " . phpversion() . "</p>";
echo "<p>✅ Server: " . ($_SERVER['SERVER_SOFTWARE'] ?? 'Unknown') . "</p>";

// Check Laravel root
$laravelRoot = dirname(__DIR__);
echo "<p>✅ Laravel Root: {$laravelRoot}</p>";

// Check .env file
$envFile = $laravelRoot . '/.env';
$envExists = file_exists($envFile);
echo "<p>✅ .env file: " . ($envExists ? 'EXISTS' : 'MISSING') . "</p>";

// Create .env if missing
if (!$envExists) {
    echo "<h2>📝 Creating .env File</h2>";
    
    $envContent = 'APP_NAME="API Management"
APP_ENV=production  
APP_KEY=base64:' . base64_encode(random_bytes(32)) . '
APP_DEBUG=false
APP_URL=https://copilotproduction.site

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=copg1493_api
DB_USERNAME=copg1493_api
DB_PASSWORD=P7H_s;Aco25Vv??J

CACHE_DRIVER=file
SESSION_DRIVER=file
QUEUE_CONNECTION=sync
LOG_CHANNEL=stack
';

    if (file_put_contents($envFile, $envContent)) {
        echo "<p style='color: green;'>✅ .env file created successfully!</p>";
    } else {
        echo "<p style='color: red;'>❌ Failed to create .env file</p>";
    }
}

// Clear cache files manually
echo "<h2>🧹 Manual Cache Clear</h2>";

$cacheFiles = [
    $laravelRoot . '/bootstrap/cache/config.php',
    $laravelRoot . '/bootstrap/cache/routes.php',
    $laravelRoot . '/bootstrap/cache/services.php',
    $laravelRoot . '/bootstrap/cache/packages.php'
];

$cleared = 0;
foreach ($cacheFiles as $file) {
    if (file_exists($file)) {
        if (unlink($file)) {
            $cleared++;
            echo "<p style='color: green;'>✅ Deleted " . basename($file) . "</p>";
        }
    }
}

echo "<p>✅ Cleared {$cleared} cache files</p>";

// Clear storage cache
$storageCache = $laravelRoot . '/storage/framework/cache/data';
if (is_dir($storageCache)) {
    $files = glob($storageCache . '/*');
    $storageCleared = 0;
    foreach ($files as $file) {
        if (is_file($file)) {
            if (unlink($file)) {
                $storageCleared++;
            }
        }
    }
    echo "<p>✅ Cleared {$storageCleared} storage cache files</p>";
}

// Test database connection
echo "<h2>🔌 Database Test</h2>";

try {
    $pdo = new PDO(
        'mysql:host=127.0.0.1;dbname=copg1493_api',
        'copg1493_api',
        'P7H_s;Aco25Vv??J'
    );
    echo "<p style='color: green;'>✅ Database connection successful!</p>";
    
    // Quick table check
    $stmt = $pdo->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "<p>✅ Found " . count($tables) . " tables in database</p>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Database failed: " . $e->getMessage() . "</p>";
}

// Create a simple index redirect
echo "<h2>🔧 Creating Simple Redirect</h2>";

$redirectContent = '<?php
// Simple redirect to handle missing routes
if (!file_exists(__DIR__ . "/../.env")) {
    die("Please run the fix script first: <a href=\"/simple-fix.php\">Simple Fix</a>");
}

// Try to load Laravel
try {
    require_once __DIR__ . "/../vendor/autoload.php";
    $app = require_once __DIR__ . "/../bootstrap/app.php";
    $kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
    $response = $kernel->handle(
        $request = Illuminate\Http\Request::capture()
    );
    $response->send();
    $kernel->terminate($request, $response);
} catch (Exception $e) {
    echo "<h1>Laravel Loading Error</h1>";
    echo "<p>Error: " . $e->getMessage() . "</p>";
    echo "<p><a href=\"/simple-fix.php\">Run Simple Fix</a></p>";
}
?>';

if (file_put_contents($laravelRoot . '/public/index_backup.php', $redirectContent)) {
    echo "<p style='color: green;'>✅ Backup index created</p>";
}

// Create basic test page
$testPage = '<!DOCTYPE html>
<html>
<head>
    <title>API Management - Test Page</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 40px; }
        .success { color: green; }
        .error { color: red; }
        .info { color: blue; }
    </style>
</head>
<body>
    <h1>🧪 API Management Test Page</h1>
    <p class="success">✅ Basic PHP is working</p>
    <p class="info">📅 Generated: ' . date('Y-m-d H:i:s') . '</p>
    
    <h2>Quick Links</h2>
    <ul>
        <li><a href="/">Main Site</a></li>
        <li><a href="/simple-fix.php">Simple Fix Script</a></li>
        <li><a href="/shared-hosting-fix.php">Shared Hosting Fix</a></li>
    </ul>
    
    <h2>Database Test</h2>
    <?php
    try {
        $pdo = new PDO("mysql:host=127.0.0.1;dbname=copg1493_api", "copg1493_api", "P7H_s;Aco25Vv??J");
        echo "<p class=\"success\">✅ Database connection working</p>";
    } catch (PDOException $e) {
        echo "<p class=\"error\">❌ Database error: " . $e->getMessage() . "</p>";
    }
    ?>
</body>
</html>';

if (file_put_contents($laravelRoot . '/public/test.php', $testPage)) {
    echo "<p style='color: green;'>✅ Test page created: <a href='/test.php' target='_blank'>View Test Page</a></p>";
}

// Summary
echo "<hr>";
echo "<h2>📊 Simple Fix Complete</h2>";

echo "<div style='background: #e8f5e8; padding: 15px; border-radius: 5px; border-left: 4px solid #28a745;'>";
echo "<h3>✅ Simple Fix Applied</h3>";
echo "<p>Basic fixes applied without system calls:</p>";
echo "<ul>";
echo "<li>✅ Created/verified .env file</li>";
echo "<li>✅ Cleared cache files manually</li>";
echo "<li>✅ Tested database connection</li>";
echo "<li>✅ Created test pages</li>";
echo "</ul>";
echo "</div>";

echo "<h3>🔗 Test Links</h3>";
echo "<ul>";
echo "<li><a href='/' target='_blank'>🏠 Main Site</a></li>";
echo "<li><a href='/test.php' target='_blank'>🧪 Test Page</a></li>";
echo "<li><a href='/shared-hosting-fix.php' target='_blank'>🛠️ Full Shared Hosting Fix</a></li>";
echo "</ul>";

echo "<h3>💡 Next Steps</h3>";
echo "<div style='background: #f8f9fa; padding: 15px; border-radius: 5px;'>";
echo "<p>If the main site still shows errors:</p>";
echo "<ol>";
echo "<li>Run the <a href='/shared-hosting-fix.php'>Shared Hosting Fix</a> for complete setup</li>";
echo "<li>Contact your hosting provider about proc_open restrictions</li>";
echo "<li>Check file permissions on storage and cache directories</li>";
echo "</ol>";
echo "</div>";

echo "<hr>";
echo "<p><small>Simple fix completed at: " . date('Y-m-d H:i:s') . "</small></p>";
?> 